/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.unit;

import java.util.Map;
import java.util.Objects;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tec.uom.se.AbstractUnit;

public final class AnnotatedUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q> {
    private static final long serialVersionUID = -5676462045106887728L;
    private final AbstractUnit<Q> actualUnit;
    private final String annotation;

    public AnnotatedUnit(AbstractUnit<Q> actualUnit, String annotation) {
        this.actualUnit = actualUnit instanceof AnnotatedUnit ? ((AnnotatedUnit)actualUnit).actualUnit : actualUnit;
        this.annotation = annotation;
    }

    public AbstractUnit<Q> getActualUnit() {
        return this.actualUnit;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getSymbol() {
        return this.actualUnit.getSymbol();
    }

    @Override
    public Map<? extends Unit<?>, Integer> getProductUnits() {
        return this.actualUnit.getProductUnits();
    }

    @Override
    public AbstractUnit<Q> toSystemUnit() {
        return this.actualUnit.getSystemUnit();
    }

    @Override
    public Dimension getDimension() {
        return this.actualUnit.getDimension();
    }

    @Override
    public UnitConverter getSystemConverter() {
        return this.actualUnit.getSystemConverter();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.actualUnit, this.annotation);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AnnotatedUnit) {
            AnnotatedUnit other = (AnnotatedUnit)obj;
            return Objects.equals(this.actualUnit, other.actualUnit) && Objects.equals(this.annotation, other.annotation);
        }
        return false;
    }
}

