/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Dimension;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tec.uom.se.AbstractConverter;
import tec.uom.se.DimensionalModel;
import tec.uom.se.format.EBNFUnitFormat;
import tec.uom.se.format.LocalUnitFormat;
import tec.uom.se.function.AddConverter;
import tec.uom.se.function.MultiplyConverter;
import tec.uom.se.function.RationalConverter;
import tec.uom.se.quantity.QuantityDimension;
import tec.uom.se.unit.AlternateUnit;
import tec.uom.se.unit.AnnotatedUnit;
import tec.uom.se.unit.ProductUnit;
import tec.uom.se.unit.TransformedUnit;
import tec.uom.se.unit.Units;

public abstract class AbstractUnit<Q extends Quantity<Q>>
implements Unit<Q>,
Comparable<Unit<Q>>,
Serializable {
    private static final long serialVersionUID = -4344589505537030204L;
    protected String name;
    protected static final Map<String, Unit<?>> SYMBOL_TO_UNIT = new HashMap();

    protected AbstractUnit() {
    }

    protected Type getActualType() {
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        return parameterizedType.getActualTypeArguments()[0].getClass().getGenericInterfaces()[0];
    }

    public boolean isSystemUnit() {
        AbstractUnit<Q> si = this.toSystemUnit();
        return this == si || this.equals(si);
    }

    protected abstract AbstractUnit<Q> toSystemUnit();

    public abstract UnitConverter getSystemConverter();

    public AnnotatedUnit<Q> annotate(String annotation) {
        return new AnnotatedUnit(this, annotation);
    }

    public static final Unit<?> parse(CharSequence charSequence) {
        return EBNFUnitFormat.getInstance().parse(charSequence);
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder();
        try {
            String string = LocalUnitFormat.getInstance().format(this, (Appendable)tmp).toString();
            return string;
        }
        catch (IOException ioException) {
            throw new Error(ioException);
        }
    }

    public final AbstractUnit<Q> getSystemUnit() {
        return this.toSystemUnit();
    }

    public final boolean isCompatible(Unit<?> that) {
        Dimension thatDimension;
        if (this == that || this.equals(that)) {
            return true;
        }
        if (!(that instanceof AbstractUnit)) {
            return false;
        }
        Dimension thisDimension = this.getDimension();
        if (thisDimension.equals(thatDimension = that.getDimension())) {
            return true;
        }
        DimensionalModel model = DimensionalModel.current();
        return model.getFundamentalDimension(thisDimension).equals(model.getFundamentalDimension(thatDimension));
    }

    public final <T extends Quantity<T>> AbstractUnit<T> asType(Class<T> type) {
        Dimension typeDimension = QuantityDimension.getInstance(type);
        if (typeDimension != null && !this.getDimension().equals(typeDimension)) {
            throw new ClassCastException("The unit: " + this + " is not compatible with quantities of type " + type);
        }
        return this;
    }

    public abstract Map<? extends Unit<?>, Integer> getProductUnits();

    public abstract Dimension getDimension();

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public final UnitConverter getConverterTo(Unit<Q> that) throws UnconvertibleException {
        Unit thatSystemUnit;
        if (this == that || this.equals(that)) {
            return AbstractConverter.IDENTITY;
        }
        Unit thisSystemUnit = this.getSystemUnit();
        if (!thisSystemUnit.equals(thatSystemUnit = that.getSystemUnit())) {
            try {
                return this.getConverterToAny(that);
            }
            catch (IncommensurableException e) {
                throw new UnconvertibleException((Throwable)e);
            }
        }
        UnitConverter thisToSI = this.getSystemConverter();
        UnitConverter thatToSI = that.getConverterTo(thatSystemUnit);
        return thatToSI.inverse().concatenate(thisToSI);
    }

    public final UnitConverter getConverterToAny(Unit<?> that) throws IncommensurableException, UnconvertibleException {
        if (!this.isCompatible(that)) {
            throw new IncommensurableException(this + " is not compatible with " + that);
        }
        AbstractUnit thatAbstr = (AbstractUnit)that;
        DimensionalModel model = DimensionalModel.current();
        Unit thisSystemUnit = this.getSystemUnit();
        UnitConverter thisToDimension = model.getDimensionalTransform(thisSystemUnit.getDimension()).concatenate(this.getSystemConverter());
        Unit thatSystemUnit = thatAbstr.getSystemUnit();
        UnitConverter thatToDimension = model.getDimensionalTransform(thatSystemUnit.getDimension()).concatenate(thatAbstr.getSystemConverter());
        return thatToDimension.inverse().concatenate(thisToDimension);
    }

    public final Unit<Q> alternate(String symbol) {
        return new AlternateUnit(this, symbol);
    }

    public final AbstractUnit<Q> transform(UnitConverter operation) {
        Unit systemUnit = this.getSystemUnit();
        UnitConverter cvtr = this.getSystemConverter().concatenate(operation);
        if (cvtr.equals(AbstractConverter.IDENTITY)) {
            return systemUnit;
        }
        return new TransformedUnit(systemUnit, cvtr);
    }

    public final AbstractUnit<Q> shift(double offset) {
        if (offset == 0.0) {
            return this;
        }
        return this.transform(new AddConverter(offset));
    }

    public final AbstractUnit<Q> multiply(double factor) {
        if (factor == 1.0) {
            return this;
        }
        if (AbstractUnit.isLongValue(factor)) {
            return this.transform(new RationalConverter(BigInteger.valueOf((long)factor), BigInteger.ONE));
        }
        return this.transform(new MultiplyConverter(factor));
    }

    private static boolean isLongValue(double value) {
        return !(value < -9.223372036854776E18) && !(value > 9.223372036854776E18) && Math.floor(value) == value;
    }

    public final Unit<?> multiply(Unit<?> that) {
        if (that instanceof AbstractUnit) {
            return this.multiply((AbstractUnit)that);
        }
        return ProductUnit.getProductInstance(this, that);
    }

    public final Unit<?> multiply(AbstractUnit<?> that) {
        if (this.equals(Units.ONE)) {
            return that;
        }
        if (that.equals(Units.ONE)) {
            return this;
        }
        return ProductUnit.getProductInstance(this, that);
    }

    public final Unit<?> inverse() {
        if (this.equals(Units.ONE)) {
            return this;
        }
        return ProductUnit.getQuotientInstance(Units.ONE, this);
    }

    public final AbstractUnit<Q> divide(double divisor) {
        if (divisor == 1.0) {
            return this;
        }
        if (AbstractUnit.isLongValue(divisor)) {
            return this.transform(new RationalConverter(BigInteger.ONE, BigInteger.valueOf((long)divisor)));
        }
        return this.transform(new MultiplyConverter(1.0 / divisor));
    }

    public final Unit<?> divide(Unit<?> that) {
        return this.multiply(that.inverse());
    }

    public final Unit<?> divide(AbstractUnit<?> that) {
        return this.multiply(that.inverse());
    }

    public final Unit<?> root(int n) {
        if (n > 0) {
            return ProductUnit.getRootInstance(this, n);
        }
        if (n == 0) {
            throw new ArithmeticException("Root's order of zero");
        }
        return Units.ONE.divide(this.root(-n));
    }

    public final Unit<?> pow(int n) {
        if (n > 0) {
            return this.multiply(this.pow(n - 1));
        }
        if (n == 0) {
            return Units.ONE;
        }
        return Units.ONE.divide(this.pow(-n));
    }

    @Override
    public int compareTo(Unit<Q> that) {
        return this.name.compareTo(that.getName()) + this.getSymbol().compareTo(that.getSymbol());
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

