/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.quantity.time;

import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.measure.Quantity;
import javax.measure.quantity.Time;
import tec.uom.se.quantity.Quantities;
import tec.uom.se.quantity.time.TimeUnitQuantity;
import tec.uom.se.spi.SI;
import tec.uom.se.spi.SIPrefix;
import tec.uom.se.unit.BaseUnit;
import tec.uom.se.unit.TransformedUnit;

public final class TimeQuantities {
    public static final TransformedUnit<Time> MINUTE = SI.MINUTE;
    public static final TransformedUnit<Time> HOUR = SI.HOUR;
    public static final TransformedUnit<Time> DAY = SI.DAY;
    public static final BaseUnit<Time> SECOND = SI.SECOND;
    public static final TransformedUnit<Time> MICROSECOND = new TransformedUnit<Time>("\u03bcs", SI.SECOND, SIPrefix.MICRO.getConverter());
    public static final TransformedUnit<Time> MILLISECOND = new TransformedUnit<Time>("ms", SI.SECOND, SIPrefix.MILLI.getConverter());
    public static final TransformedUnit<Time> NANOSECOND = new TransformedUnit<Time>("ns", SI.SECOND, SIPrefix.NANO.getConverter());

    private TimeQuantities() {
    }

    public static Quantity<Time> getQuantity(Temporal temporalA, Temporal temporalB) {
        long days = ChronoUnit.DAYS.between(temporalA, temporalB);
        return Quantities.getQuantity(days, SI.DAY);
    }

    public static Quantity<Time> getQuantity(LocalTime localTimeA, LocalTime localTimeB) {
        long hours = ChronoUnit.HOURS.between(localTimeA, localTimeB);
        return Quantities.getQuantity(hours, SI.HOUR);
    }

    public static Quantity<Time> getQuantity(Temporal temporalA, Supplier<TemporalAdjuster> supplier) {
        Temporal temporalB = temporalA.with(supplier.get());
        return TimeQuantities.getQuantity(temporalA, temporalB);
    }

    public static Quantity<Time> getQuantity(LocalTime localTimeA, Supplier<TemporalAdjuster> supplier) {
        LocalTime localTimeB = localTimeA.with(supplier.get());
        return TimeQuantities.getQuantity(localTimeA, localTimeB);
    }

    public static TimeUnitQuantity getQuantity(TimeUnit timeUnit, Integer number) {
        return new TimeUnitQuantity(Objects.requireNonNull(timeUnit), Objects.requireNonNull(number));
    }

    public static TimeUnitQuantity getQuantity(Quantity<Time> quantity) {
        Quantity seconds = Objects.requireNonNull(quantity).to(SECOND);
        return new TimeUnitQuantity(TimeUnit.SECONDS, seconds.getValue().intValue());
    }
}

