/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.quantity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.uom.se.AbstractConverter;
import tec.uom.se.AbstractQuantity;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.quantity.Quantities;

final class DecimalQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q>
implements Serializable {
    private static final long serialVersionUID = 6504081836032983882L;
    private final BigDecimal value;

    public DecimalQuantity(BigDecimal value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        return unit.equals(unit) ? this.value.doubleValue() : unit.getConverterTo(unit).convert(this.value.doubleValue());
    }

    @Override
    public BigDecimal decimalValue(Unit<Q> unit, MathContext ctx) throws ArithmeticException {
        return super.getUnit().equals(unit) ? this.value : ((AbstractConverter)unit.getConverterTo(unit)).convert(this.value, ctx);
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        if (this.getUnit().equals(that.getUnit())) {
            return Quantities.getQuantity(this.value.add(this.toBigDecimal(that.getValue()), MathContext.DECIMAL128), this.getUnit());
        }
        Quantity converted = that.to(this.getUnit());
        return Quantities.getQuantity(this.value.add(this.toBigDecimal(converted.getValue())), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        if (this.getUnit().equals(that.getUnit())) {
            return Quantities.getQuantity(this.value.subtract(this.toBigDecimal(that.getValue()), MathContext.DECIMAL128), this.getUnit());
        }
        Quantity converted = that.to(this.getUnit());
        return Quantities.getQuantity(this.value.subtract(this.toBigDecimal(converted.getValue()), MathContext.DECIMAL128), this.getUnit());
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return new DecimalQuantity<Q>(this.value.multiply(this.toBigDecimal(that.getValue()), MathContext.DECIMAL128), this.getUnit().multiply(that.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> multiply(Number that) {
        return Quantities.getQuantity(this.value.multiply(this.toBigDecimal(that), MathContext.DECIMAL128), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> divide(Number that) {
        return Quantities.getQuantity(this.value.divide(this.toBigDecimal(that), MathContext.DECIMAL128), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> inverse() {
        return Quantities.getQuantity(BigDecimal.ONE.divide(this.value), this.getUnit().inverse());
    }

    @Override
    protected long longValue(Unit<Q> unit) {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    @Override
    public boolean isBig() {
        return true;
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return new DecimalQuantity<Q>(this.value.divide(this.toBigDecimal(that.getValue()), MathContext.DECIMAL128), this.getUnit().divide(that.getUnit()));
    }

    private BigDecimal toBigDecimal(Number value) {
        if (BigDecimal.class.isInstance(value)) {
            return (BigDecimal)BigDecimal.class.cast(value);
        }
        if (BigInteger.class.isInstance(value)) {
            return new BigDecimal((BigInteger)BigInteger.class.cast(value));
        }
        return BigDecimal.valueOf(value.doubleValue());
    }
}

