/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.format;

import java.io.IOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import javax.measure.Quantity;
import javax.measure.format.Parser;
import javax.measure.format.ParserException;
import javax.measure.format.UnitFormat;
import tec.uom.se.AbstractQuantity;
import tec.uom.se.ComparableQuantity;
import tec.uom.se.format.FormatBehavior;
import tec.uom.se.format.LocalUnitFormat;
import tec.uom.se.format.NumberSpaceUnitFormat;
import tec.uom.se.format.StandardFormat;

public abstract class QuantityFormat
extends Format
implements Parser<CharSequence, ComparableQuantity> {
    private static final long serialVersionUID = -4628006924354248662L;
    private static final NumberSpaceUnitFormat DEFAULT = new NumberSpaceUnitFormat(NumberFormat.getInstance(), LocalUnitFormat.getInstance());
    private static final StandardFormat STANDARD = new StandardFormat();

    public static QuantityFormat getInstance() {
        return DEFAULT;
    }

    public static QuantityFormat getInstance(NumberFormat numberFormat, UnitFormat unitFormat) {
        return new NumberSpaceUnitFormat(numberFormat, unitFormat);
    }

    public static QuantityFormat getInstance(FormatBehavior style) {
        switch (style) {
            case LOCALE_NEUTRAL: {
                return STANDARD;
            }
            case LOCALE_SENSITIVE: {
                return DEFAULT;
            }
        }
        return DEFAULT;
    }

    public abstract Appendable format(Quantity<?> var1, Appendable var2) throws IOException;

    public abstract ComparableQuantity<?> parse(CharSequence var1, ParsePosition var2) throws IllegalArgumentException, ParserException;

    public abstract ComparableQuantity<?> parse(CharSequence var1) throws IllegalArgumentException, ParserException;

    @Override
    public final StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (!(obj instanceof AbstractQuantity)) {
            throw new IllegalArgumentException("obj: Not an instance of Measure");
        }
        if (toAppendTo == null || pos == null) {
            throw new NullPointerException();
        }
        try {
            return (StringBuffer)this.format((AbstractQuantity)obj, toAppendTo);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    public final Quantity<?> parseObject(String source, ParsePosition pos) {
        try {
            return this.parse(source, pos);
        }
        catch (IllegalArgumentException | ParserException e) {
            return null;
        }
    }

    public final StringBuilder format(AbstractQuantity<?> measure, StringBuilder dest) {
        try {
            return (StringBuilder)this.format(measure, (Appendable)dest);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

