/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.spi.SystemOfUnits;
import tec.units.ri.AbstractUnit;

public abstract class AbstractSystemOfUnits
implements SystemOfUnits {
    protected static final Logger logger = Logger.getLogger(AbstractSystemOfUnits.class.getName());
    protected final Set<Unit<?>> units = new HashSet();
    protected final Map<Class<? extends Quantity>, Unit> quantityToUnit = new HashMap<Class<? extends Quantity>, Unit>();
    protected static final double E = Math.E;

    public abstract String getName();

    public Set<Unit<?>> getUnits() {
        if (logger.isLoggable(Level.FINEST)) {
            for (Unit<?> u : this.units) {
                logger.log(Level.FINEST, u + "; D: " + u.getDimension() + "; C: " + u.getClass());
            }
        }
        return this.units;
    }

    public Set<? extends Unit<?>> getUnits(Dimension dimension) {
        HashSet set = new HashSet();
        for (Unit<?> unit : this.getUnits()) {
            if (!dimension.equals(unit.getDimension())) continue;
            set.add(unit);
        }
        return set;
    }

    public <Q extends Quantity<Q>> Unit<Q> getUnit(Class<Q> quantityType) {
        return this.quantityToUnit.get(quantityType);
    }

    protected <U extends Unit<?>> U addUnit(U unit, String name, String symbol) {
        if (name != null && symbol != null && unit instanceof AbstractUnit) {
            AbstractUnit aUnit = (AbstractUnit)unit;
            aUnit.setName(name);
            aUnit.setSymbol(symbol);
            this.units.add(aUnit);
            return (U)aUnit;
        }
        if (name != null && unit instanceof AbstractUnit) {
            AbstractUnit aUnit = (AbstractUnit)unit;
            aUnit.setName(name);
            this.units.add(aUnit);
            return (U)aUnit;
        }
        this.units.add(unit);
        return unit;
    }

    protected <U extends Unit<?>> U addUnit(U unit, String name) {
        if (name != null && unit instanceof AbstractUnit) {
            AbstractUnit aUnit = (AbstractUnit)unit;
            aUnit.setName(name);
            this.units.add(aUnit);
            return (U)aUnit;
        }
        this.units.add(unit);
        return unit;
    }

    protected static class Helper {
        protected Helper() {
        }

        static Set<Unit<?>> getUnitsOfDimension(Set<Unit<?>> units, Dimension dimension) {
            if (dimension != null) {
                HashSet dimSet = new HashSet();
                for (Unit<?> u : units) {
                    if (!dimension.equals(u.getDimension())) continue;
                    dimSet.add(u);
                }
                return dimSet;
            }
            return null;
        }

        public static <U extends Unit<?>> U addUnit(Set<Unit<?>> units, U unit, String name) {
            if (name != null && unit instanceof AbstractUnit) {
                AbstractUnit aUnit = (AbstractUnit)unit;
                aUnit.setName(name);
                units.add(aUnit);
                return (U)aUnit;
            }
            units.add(unit);
            return unit;
        }

        public static <U extends Unit<?>> U addUnit(Set<Unit<?>> units, U unit, String name, String symbol) {
            if (name != null && symbol != null && unit instanceof AbstractUnit) {
                AbstractUnit aUnit = (AbstractUnit)unit;
                aUnit.setName(name);
                aUnit.setSymbol(symbol);
                units.add(aUnit);
                return (U)aUnit;
            }
            if (name != null && unit instanceof AbstractUnit) {
                AbstractUnit aUnit = (AbstractUnit)unit;
                aUnit.setName(name);
                units.add(aUnit);
                return (U)aUnit;
            }
            units.add(unit);
            return unit;
        }
    }
}

