/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.quantity;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.units.ri.AbstractUnit;
import tec.units.ri.unit.BaseUnit;
import tec.units.ri.unit.Units;

public final class QuantityDimension
implements Dimension {
    private static final Logger logger = Logger.getLogger(QuantityDimension.class.getName());
    public static final Dimension NONE = new QuantityDimension(AbstractUnit.ONE);
    public static final Dimension LENGTH = new QuantityDimension('L');
    public static final Dimension MASS = new QuantityDimension('M');
    public static final Dimension TIME = new QuantityDimension('T');
    public static final Dimension ELECTRIC_CURRENT = new QuantityDimension('I');
    public static final Dimension TEMPERATURE = new QuantityDimension('\u0398');
    public static final Dimension AMOUNT_OF_SUBSTANCE = new QuantityDimension('N');
    public static final Dimension LUMINOUS_INTENSITY = new QuantityDimension('J');
    private final Unit<?> pseudoUnit;

    public static <Q extends Quantity<Q>> Dimension getInstance(Class<Q> quantityType) {
        Unit siUnit = Units.getInstance().getUnit(quantityType);
        if (siUnit == null) {
            logger.log(Level.FINER, "Quantity type: " + quantityType + " unknown");
        }
        return siUnit != null ? siUnit.getDimension() : null;
    }

    QuantityDimension(char symbol) {
        this.pseudoUnit = new BaseUnit("[" + symbol + ']', NONE);
    }

    public static QuantityDimension getInstance(char symbol) {
        return new QuantityDimension(symbol);
    }

    private QuantityDimension(Unit<?> pseudoUnit) {
        this.pseudoUnit = pseudoUnit;
    }

    public Dimension multiply(Dimension that) {
        return that instanceof QuantityDimension ? this.multiply((QuantityDimension)that) : that.multiply((Dimension)this);
    }

    public QuantityDimension multiply(QuantityDimension that) {
        return new QuantityDimension(this.pseudoUnit.multiply(that.pseudoUnit));
    }

    public Dimension divide(Dimension that) {
        return this.multiply(that.pow(-1));
    }

    public QuantityDimension divide(QuantityDimension that) {
        return this.multiply(that.pow(-1));
    }

    public final QuantityDimension pow(int n) {
        return new QuantityDimension(this.pseudoUnit.pow(n));
    }

    public final QuantityDimension root(int n) {
        return new QuantityDimension(this.pseudoUnit.root(n));
    }

    public Map<? extends QuantityDimension, Integer> getProductDimensions() {
        Map pseudoUnits = this.pseudoUnit.getProductUnits();
        if (pseudoUnits == null) {
            return null;
        }
        HashMap fundamentalDimensions = new HashMap();
        for (Map.Entry entry : pseudoUnits.entrySet()) {
            fundamentalDimensions.put(new QuantityDimension((Unit)entry.getKey()), entry.getValue());
        }
        return fundamentalDimensions;
    }

    public String toString() {
        return this.pseudoUnit.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QuantityDimension) {
            QuantityDimension other = (QuantityDimension)obj;
            return Objects.equals(this.pseudoUnit, other.pseudoUnit);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.pseudoUnit);
    }
}

