/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.quantity;

import javax.measure.Quantity;
import javax.measure.Unit;
import tec.units.ri.AbstractQuantity;
import tec.units.ri.format.QuantityFormat;
import tec.units.ri.quantity.NumberQuantity;

final class DoubleQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q> {
    final double value;

    public DoubleQuantity(double value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        return super.getUnit().equals(unit) ? this.value : super.getUnit().getConverterTo(unit).convert(this.value);
    }

    @Override
    public long longValue(Unit<Q> unit) {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    public Quantity<Q> add(Quantity<Q> that) {
        Quantity converted = that.to(this.getUnit());
        return NumberQuantity.of(this.value + converted.getValue().doubleValue(), this.getUnit());
    }

    public Quantity<Q> subtract(Quantity<Q> that) {
        Quantity converted = that.to(this.getUnit());
        return NumberQuantity.of(this.value - converted.getValue().doubleValue(), this.getUnit());
    }

    public Quantity<?> multiply(Quantity<?> that) {
        return new DoubleQuantity<Q>(this.value * that.getValue().doubleValue(), this.getUnit().multiply(that.getUnit()));
    }

    public Quantity<Q> multiply(Number that) {
        return NumberQuantity.of(this.value * that.doubleValue(), this.getUnit());
    }

    public Quantity<?> divide(Quantity<?> that) {
        return new DoubleQuantity<Q>(this.value / that.getValue().doubleValue(), this.getUnit().divide(that.getUnit()));
    }

    public Quantity<Q> divide(Number that) {
        return NumberQuantity.of(this.value / that.doubleValue(), this.getUnit());
    }

    public AbstractQuantity<Q> inverse() {
        return NumberQuantity.of(1.0 / this.value, this.getUnit().inverse());
    }

    @Override
    public String toString() {
        return QuantityFormat.getInstance().format(this);
    }

    private static String nosci(double d) {
        if (d < 0.0) {
            return "-" + DoubleQuantity.nosci(-d);
        }
        String javaString = String.valueOf(d);
        int indexOfE = javaString.indexOf("E");
        if (indexOfE == -1) {
            return javaString;
        }
        StringBuffer sb = new StringBuffer();
        if (d > 1.0) {
            String sciDecimal;
            int sciDecimalLength;
            int exp = Integer.parseInt(javaString.substring(indexOfE + 1));
            if (exp == (sciDecimalLength = (sciDecimal = javaString.substring(2, indexOfE)).length())) {
                sb.append(javaString.charAt(0));
                sb.append(sciDecimal);
            } else if (exp > sciDecimalLength) {
                sb.append(javaString.charAt(0));
                sb.append(sciDecimal);
                for (int i = 0; i < exp - sciDecimalLength; ++i) {
                    sb.append('0');
                }
            } else if (exp < sciDecimalLength) {
                sb.append(javaString.charAt(0));
                sb.append(sciDecimal.substring(0, exp));
                sb.append('.');
                for (int i = exp; i < sciDecimalLength; ++i) {
                    sb.append(sciDecimal.charAt(i));
                }
            }
            return sb.toString();
        }
        return javaString;
    }
}

