/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.format;

import java.io.IOException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import javax.measure.format.UnitFormat;
import tec.units.ri.AbstractQuantity;
import tec.units.ri.AbstractUnit;
import tec.units.ri.format.Parser;
import tec.units.ri.format.SimpleUnitFormat;
import tec.units.ri.internal.format.l10n.DecimalFormat;
import tec.units.ri.internal.format.l10n.NumberFormat;
import tec.units.ri.quantity.NumberQuantity;
import tec.units.ri.unit.Units;

public abstract class QuantityFormat
implements Parser<CharSequence, Quantity> {
    private static final NumberSpaceUnit DEFAULT = new NumberSpaceUnit(NumberFormat.getInstance(), SimpleUnitFormat.getInstance());
    private static final NumberSpaceUnit EBNF = new NumberSpaceUnit(NumberFormat.getInstance(), SimpleUnitFormat.getInstance());
    private static final Standard STANDARD = new Standard();

    public static QuantityFormat getInstance() {
        return DEFAULT;
    }

    public abstract Appendable format(Quantity<?> var1, Appendable var2) throws IOException;

    abstract AbstractQuantity<?> parse(CharSequence var1, int var2) throws IllegalArgumentException, ParserException;

    public final StringBuilder format(Quantity<?> q, StringBuilder dest) {
        try {
            return (StringBuilder)this.format(q, (Appendable)dest);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final String format(Quantity q) {
        if (q instanceof AbstractQuantity) {
            return this.format((AbstractQuantity)q, new StringBuilder()).toString();
        }
        return this.format(q, new StringBuilder()).toString();
    }

    static int getFractionDigitsCount(double d) {
        if (d >= 1.0) {
            d -= (double)((long)d);
        }
        if (d == 0.0) {
            return 0;
        }
        d *= 10.0;
        int count = 1;
        while (d - (double)((long)d) != 0.0) {
            d *= 10.0;
            ++count;
        }
        return count;
    }

    private static final class Standard
    extends QuantityFormat {
        private Standard() {
        }

        public Appendable format(Quantity q, Appendable dest) throws IOException {
            Unit unit = q.getUnit();
            Number number = q.getValue();
            dest.append(number.toString());
            if (q.getUnit().equals(Units.ONE)) {
                return dest;
            }
            dest.append(' ');
            return SimpleUnitFormat.getInstance().format(unit, dest);
        }

        @Override
        AbstractQuantity<?> parse(CharSequence csq, int index) throws ParserException {
            int endDecimal;
            int startDecimal;
            for (startDecimal = index; startDecimal < csq.length() && Character.isWhitespace(csq.charAt(startDecimal)); ++startDecimal) {
            }
            for (endDecimal = startDecimal + 1; endDecimal < csq.length() && !Character.isWhitespace(csq.charAt(endDecimal)); ++endDecimal) {
            }
            Double decimal = new Double(csq.subSequence(startDecimal, endDecimal).toString());
            Unit<?> unit = SimpleUnitFormat.getInstance().parse(csq, index);
            return NumberQuantity.of(decimal, unit);
        }

        @Override
        public AbstractQuantity<?> parse(CharSequence csq) throws ParserException {
            return this.parse(csq, 0);
        }
    }

    private static final class NumberSpaceUnit
    extends QuantityFormat {
        private final DecimalFormat decimalFormat = new DecimalFormat();
        private final NumberFormat numberFormat;
        private final UnitFormat unitFormat;

        private NumberSpaceUnit(NumberFormat numberFormat, UnitFormat unitFormat) {
            this.numberFormat = numberFormat;
            this.unitFormat = unitFormat;
        }

        @Override
        public Appendable format(Quantity<?> quantity, Appendable dest) throws IOException {
            int fract = 0;
            if (quantity != null && quantity.getValue() != null) {
                fract = NumberSpaceUnit.getFractionDigitsCount(quantity.getValue().doubleValue());
            }
            if (fract > 1) {
                this.decimalFormat.setMaximumFractionDigits(fract + 1);
            }
            dest.append(this.decimalFormat.format(quantity.getValue()));
            if (quantity.getUnit().equals(AbstractUnit.ONE)) {
                return dest;
            }
            dest.append(' ');
            return this.unitFormat.format(quantity.getUnit(), dest);
        }

        @Override
        AbstractQuantity<?> parse(CharSequence csq, int index) throws IllegalArgumentException, ParserException {
            String str = csq.toString();
            Number number = null;
            if (number == null) {
                throw new IllegalArgumentException("Number cannot be parsed");
            }
            Unit unit = this.unitFormat.parse(csq);
            if (number instanceof Long) {
                return NumberQuantity.of(number.longValue(), unit);
            }
            if (number instanceof Double) {
                return NumberQuantity.of(number.doubleValue(), unit);
            }
            if (number instanceof Integer) {
                return NumberQuantity.of(number.intValue(), unit);
            }
            throw new UnsupportedOperationException("Number of type " + number.getClass() + " are not supported");
        }

        @Override
        public AbstractQuantity<?> parse(CharSequence csq) throws IllegalArgumentException, ParserException {
            return this.parse(csq, 0);
        }
    }
}

