/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri;

import java.util.ArrayList;
import java.util.List;
import javax.measure.UnitConverter;

public abstract class AbstractConverter
implements UnitConverter {
    protected static final double PI = Math.PI;
    public static final AbstractConverter IDENTITY = new Identity();

    protected AbstractConverter() {
    }

    public AbstractConverter concatenate(AbstractConverter that) {
        return that == IDENTITY ? this : new Pair(this, that);
    }

    public boolean isIdentity() {
        return false;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract AbstractConverter inverse();

    public UnitConverter concatenate(UnitConverter converter) {
        return converter == IDENTITY ? this : new Pair(this, converter);
    }

    public List<? extends UnitConverter> getConversionSteps() {
        ArrayList<AbstractConverter> steps = new ArrayList<AbstractConverter>();
        steps.add(this);
        return steps;
    }

    public Number convert(Number value) {
        return this.convert(value.doubleValue());
    }

    public abstract double convert(double var1);

    public static final class Pair
    extends AbstractConverter {
        private final UnitConverter left;
        private final UnitConverter right;

        public Pair(UnitConverter left, UnitConverter right) {
            this.left = left;
            this.right = right;
        }

        public boolean isLinear() {
            return this.left.isLinear() && this.right.isLinear();
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        public List<UnitConverter> getConversionSteps() {
            ArrayList<UnitConverter> steps = new ArrayList<UnitConverter>();
            List leftCompound = this.left.getConversionSteps();
            List rightCompound = this.right.getConversionSteps();
            steps.addAll(leftCompound);
            steps.addAll(rightCompound);
            return steps;
        }

        @Override
        public Pair inverse() {
            return new Pair(this.right.inverse(), this.left.inverse());
        }

        @Override
        public double convert(double value) {
            return this.left.convert(this.right.convert(value));
        }

        @Override
        public boolean equals(Object cvtr) {
            if (this == cvtr) {
                return true;
            }
            if (!(cvtr instanceof Pair)) {
                return false;
            }
            Pair that = (Pair)cvtr;
            return this.left.equals(that.left) && this.right.equals(that.right);
        }

        @Override
        public int hashCode() {
            return this.left.hashCode() + this.right.hashCode();
        }

        public UnitConverter getLeft() {
            return this.left;
        }

        public UnitConverter getRight() {
            return this.right;
        }
    }

    private static final class Identity
    extends AbstractConverter {
        private Identity() {
        }

        @Override
        public boolean isIdentity() {
            return true;
        }

        @Override
        public Identity inverse() {
            return this;
        }

        @Override
        public double convert(double value) {
            return value;
        }

        @Override
        public UnitConverter concatenate(UnitConverter converter) {
            return converter;
        }

        @Override
        public boolean equals(Object cvtr) {
            return cvtr instanceof Identity;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        public boolean isLinear() {
            return true;
        }
    }
}

