/*
 * Decompiled with CFR 0.152.
 */
package com.razz.eva.uow;

import com.razz.eva.persistence.PersistenceException;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\n\u000bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u0082\u0001\u0002\f\r\u00a8\u0006\u000e"}, d2={"Lcom/razz/eva/uow/Retry;", "", "<init>", "()V", "getNextDelay", "Ljava/time/Duration;", "currentAttempt", "", "ex", "Lcom/razz/eva/persistence/PersistenceException;", "StaleRecordFixedRetry", "UniqueViolationFixedRetry", "Lcom/razz/eva/uow/Retry$StaleRecordFixedRetry;", "Lcom/razz/eva/uow/Retry$UniqueViolationFixedRetry;", "eva-uow"})
public abstract sealed class Retry {
    private Retry() {
    }

    @Nullable
    public abstract Duration getNextDelay(int var1, @NotNull PersistenceException var2);

    public /* synthetic */ Retry(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/razz/eva/uow/Retry$StaleRecordFixedRetry;", "Lcom/razz/eva/uow/Retry;", "attempts", "", "staleRecordDelay", "Ljava/time/Duration;", "<init>", "(ILjava/time/Duration;)V", "getAttempts", "()I", "getStaleRecordDelay", "()Ljava/time/Duration;", "getNextDelay", "currentAttempt", "ex", "Lcom/razz/eva/persistence/PersistenceException;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "eva-uow"})
    public static final class StaleRecordFixedRetry
    extends Retry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int attempts;
        @NotNull
        private final Duration staleRecordDelay;
        @NotNull
        private static final StaleRecordFixedRetry DEFAULT;

        public StaleRecordFixedRetry(int attempts, @NotNull Duration staleRecordDelay) {
            Intrinsics.checkNotNullParameter((Object)staleRecordDelay, (String)"staleRecordDelay");
            super(null);
            this.attempts = attempts;
            this.staleRecordDelay = staleRecordDelay;
        }

        public final int getAttempts() {
            return this.attempts;
        }

        @NotNull
        public final Duration getStaleRecordDelay() {
            return this.staleRecordDelay;
        }

        @Override
        @Nullable
        public Duration getNextDelay(int currentAttempt, @NotNull PersistenceException ex) {
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            return this.attempts <= currentAttempt ? null : (ex instanceof PersistenceException.StaleRecordException ? this.staleRecordDelay : null);
        }

        public final int component1() {
            return this.attempts;
        }

        @NotNull
        public final Duration component2() {
            return this.staleRecordDelay;
        }

        @NotNull
        public final StaleRecordFixedRetry copy(int attempts, @NotNull Duration staleRecordDelay) {
            Intrinsics.checkNotNullParameter((Object)staleRecordDelay, (String)"staleRecordDelay");
            return new StaleRecordFixedRetry(attempts, staleRecordDelay);
        }

        public static /* synthetic */ StaleRecordFixedRetry copy$default(StaleRecordFixedRetry staleRecordFixedRetry, int n, Duration duration, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = staleRecordFixedRetry.attempts;
            }
            if ((n2 & 2) != 0) {
                duration = staleRecordFixedRetry.staleRecordDelay;
            }
            return staleRecordFixedRetry.copy(n, duration);
        }

        @NotNull
        public String toString() {
            return "StaleRecordFixedRetry(attempts=" + this.attempts + ", staleRecordDelay=" + this.staleRecordDelay + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.attempts);
            result = result * 31 + this.staleRecordDelay.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StaleRecordFixedRetry)) {
                return false;
            }
            StaleRecordFixedRetry staleRecordFixedRetry = (StaleRecordFixedRetry)other;
            if (this.attempts != staleRecordFixedRetry.attempts) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.staleRecordDelay, (Object)staleRecordFixedRetry.staleRecordDelay);
        }

        static {
            Duration duration = Duration.ofMillis(100L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
            DEFAULT = new StaleRecordFixedRetry(1, duration);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/razz/eva/uow/Retry$StaleRecordFixedRetry$Companion;", "", "<init>", "()V", "DEFAULT", "Lcom/razz/eva/uow/Retry$StaleRecordFixedRetry;", "getDEFAULT", "()Lcom/razz/eva/uow/Retry$StaleRecordFixedRetry;", "eva-uow"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final StaleRecordFixedRetry getDEFAULT() {
                return DEFAULT;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/razz/eva/uow/Retry$UniqueViolationFixedRetry;", "Lcom/razz/eva/uow/Retry;", "attempts", "", "uniqueModelDelay", "Ljava/time/Duration;", "<init>", "(ILjava/time/Duration;)V", "getAttempts", "()I", "getUniqueModelDelay", "()Ljava/time/Duration;", "getNextDelay", "currentAttempt", "ex", "Lcom/razz/eva/persistence/PersistenceException;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "eva-uow"})
    public static final class UniqueViolationFixedRetry
    extends Retry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int attempts;
        @NotNull
        private final Duration uniqueModelDelay;
        @NotNull
        private static final UniqueViolationFixedRetry DEFAULT;

        public UniqueViolationFixedRetry(int attempts, @NotNull Duration uniqueModelDelay) {
            Intrinsics.checkNotNullParameter((Object)uniqueModelDelay, (String)"uniqueModelDelay");
            super(null);
            this.attempts = attempts;
            this.uniqueModelDelay = uniqueModelDelay;
        }

        public final int getAttempts() {
            return this.attempts;
        }

        @NotNull
        public final Duration getUniqueModelDelay() {
            return this.uniqueModelDelay;
        }

        @Override
        @Nullable
        public Duration getNextDelay(int currentAttempt, @NotNull PersistenceException ex) {
            PersistenceException persistenceException;
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            return this.attempts <= currentAttempt ? null : ((persistenceException = ex) instanceof PersistenceException.UniqueModelRecordViolationException ? this.uniqueModelDelay : (persistenceException instanceof PersistenceException.ModelRecordConstraintViolationException ? this.uniqueModelDelay : null));
        }

        public final int component1() {
            return this.attempts;
        }

        @NotNull
        public final Duration component2() {
            return this.uniqueModelDelay;
        }

        @NotNull
        public final UniqueViolationFixedRetry copy(int attempts, @NotNull Duration uniqueModelDelay) {
            Intrinsics.checkNotNullParameter((Object)uniqueModelDelay, (String)"uniqueModelDelay");
            return new UniqueViolationFixedRetry(attempts, uniqueModelDelay);
        }

        public static /* synthetic */ UniqueViolationFixedRetry copy$default(UniqueViolationFixedRetry uniqueViolationFixedRetry, int n, Duration duration, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = uniqueViolationFixedRetry.attempts;
            }
            if ((n2 & 2) != 0) {
                duration = uniqueViolationFixedRetry.uniqueModelDelay;
            }
            return uniqueViolationFixedRetry.copy(n, duration);
        }

        @NotNull
        public String toString() {
            return "UniqueViolationFixedRetry(attempts=" + this.attempts + ", uniqueModelDelay=" + this.uniqueModelDelay + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.attempts);
            result = result * 31 + this.uniqueModelDelay.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UniqueViolationFixedRetry)) {
                return false;
            }
            UniqueViolationFixedRetry uniqueViolationFixedRetry = (UniqueViolationFixedRetry)other;
            if (this.attempts != uniqueViolationFixedRetry.attempts) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.uniqueModelDelay, (Object)uniqueViolationFixedRetry.uniqueModelDelay);
        }

        static {
            Duration duration = Duration.ofMillis(100L);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
            DEFAULT = new UniqueViolationFixedRetry(1, duration);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/razz/eva/uow/Retry$UniqueViolationFixedRetry$Companion;", "", "<init>", "()V", "DEFAULT", "Lcom/razz/eva/uow/Retry$UniqueViolationFixedRetry;", "getDEFAULT", "()Lcom/razz/eva/uow/Retry$UniqueViolationFixedRetry;", "eva-uow"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final UniqueViolationFixedRetry getDEFAULT() {
                return DEFAULT;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

