/*
 * Decompiled with CFR 0.152.
 */
package com.razz.eva.tracing;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.ExecuteListenerProvider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/razz/eva/tracing/QueryTracingListenerProvider;", "Lorg/jooq/ExecuteListenerProvider;", "openTelemetry", "Lio/opentelemetry/api/OpenTelemetry;", "<init>", "(Lio/opentelemetry/api/OpenTelemetry;)V", "provide", "Lorg/jooq/ExecuteListener;", "TracingListener", "eva-tracing"})
public final class QueryTracingListenerProvider
implements ExecuteListenerProvider {
    @NotNull
    private final OpenTelemetry openTelemetry;

    public QueryTracingListenerProvider(@NotNull OpenTelemetry openTelemetry) {
        Intrinsics.checkNotNullParameter((Object)openTelemetry, (String)"openTelemetry");
        this.openTelemetry = openTelemetry;
    }

    @NotNull
    public ExecuteListener provide() {
        return new TracingListener(this.openTelemetry);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/razz/eva/tracing/QueryTracingListenerProvider$TracingListener;", "Lorg/jooq/ExecuteListener;", "openTelemetry", "Lio/opentelemetry/api/OpenTelemetry;", "<init>", "(Lio/opentelemetry/api/OpenTelemetry;)V", "span", "Lio/opentelemetry/api/trace/Span;", "executeStart", "", "context", "Lorg/jooq/ExecuteContext;", "executeEnd", "ctx", "exception", "eva-tracing"})
    private static final class TracingListener
    implements ExecuteListener {
        @NotNull
        private final OpenTelemetry openTelemetry;
        @Nullable
        private Span span;

        public TracingListener(@NotNull OpenTelemetry openTelemetry) {
            Intrinsics.checkNotNullParameter((Object)openTelemetry, (String)"openTelemetry");
            this.openTelemetry = openTelemetry;
        }

        public void executeStart(@NotNull ExecuteContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Span rootSpan = Span.fromContextOrNull((Context)Context.current());
            if (rootSpan != null) {
                SpanBuilder spanBuilder = this.openTelemetry.getTracer("JOOQ").spanBuilder("PostgreSQL").setAttribute("db.system", "postgresql");
                String string = context.sql();
                if (string == null) {
                    string = "";
                }
                this.span = spanBuilder.setAttribute("db.statement", string).setSpanKind(SpanKind.CLIENT).startSpan();
            }
        }

        public void executeEnd(@NotNull ExecuteContext ctx) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Span span = this.span;
                if (span == null) break block0;
                span.end();
            }
        }

        public void exception(@NotNull ExecuteContext ctx) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                SQLException ex = ctx.sqlException();
                if (ex == null) break block2;
                Span span = this.span;
                if (span != null) {
                    span.recordException((Throwable)ex);
                }
                Span span2 = this.span;
                if (span2 != null) {
                    span2.end();
                }
            }
        }
    }
}

