/*
 * Decompiled with CFR 0.152.
 */
package com.razz.serialization.json;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002J\u000e\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000eJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/razz/serialization/json/InstantMillisSerializer;", "Lkotlinx/serialization/KSerializer;", "Ljava/time/Instant;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "formatter", "Ljava/time/format/DateTimeFormatter;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "formatToString", "", "value", "parseFromString", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "eva-serialization"})
public final class InstantMillisSerializer
implements KSerializer<Instant> {
    @NotNull
    public static final InstantMillisSerializer INSTANCE = new InstantMillisSerializer();
    @NotNull
    private static final DateTimeFormatter formatter;
    @NotNull
    private static final SerialDescriptor descriptor;

    private InstantMillisSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public Instant deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        Instant instant = Instant.parse(decoder.decodeString()).truncatedTo(ChronoUnit.MILLIS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"parse(decoder.decodeStri\u2026atedTo(ChronoUnit.MILLIS)");
        return instant;
    }

    public void serialize(@NotNull Encoder encoder, @NotNull Instant value) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        encoder.encodeString(this.formatToString(value));
    }

    @NotNull
    public final String formatToString(@NotNull Instant value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = formatter.format(value.atZone(ZoneOffset.UTC));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatter.format(value.atZone(UTC))");
        return string;
    }

    @NotNull
    public final Instant parseFromString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Instant instant = Instant.parse(value);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"parse(value)");
        return instant;
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(\"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'\")");
        formatter = dateTimeFormatter;
        descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"Instant", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));
    }
}

