/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.tree.components;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.contrib.tree.components.INodeRenderFactory;
import org.apache.tapestry.contrib.tree.model.ITreeModelSource;
import org.apache.tapestry.contrib.tree.model.ITreeRowSource;
import org.apache.tapestry.contrib.tree.model.ITreeStateListener;
import org.apache.tapestry.contrib.tree.model.ITreeStateModel;
import org.apache.tapestry.contrib.tree.model.TreeRowObject;
import org.apache.tapestry.contrib.tree.model.TreeStateEvent;
import org.apache.tapestry.contrib.tree.simple.SimpleNodeRenderFactory;
import org.apache.tapestry.engine.IPageLoader;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.spec.ComponentSpecification;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.util.ComponentAddress;

public abstract class TreeNodeView
extends BaseComponent
implements PageDetachListener {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$contrib$tree$components$TreeNodeView == null ? (class$org$apache$tapestry$contrib$tree$components$TreeNodeView = TreeNodeView.class$("org.apache.tapestry.contrib.tree.components.TreeNodeView")) : class$org$apache$tapestry$contrib$tree$components$TreeNodeView));
    private Boolean m_objNodeState;
    private Boolean m_objShowNodeImages;
    private Boolean m_objMakeNodeDirect;
    private INodeRenderFactory m_objNodeRenderFactory;
    private IAsset m_objOpenNodeImage;
    private IAsset m_objCloseNodeImage;
    private int m_CurrentForeachConnectImageValue = 2;
    static /* synthetic */ Class class$org$apache$tapestry$contrib$tree$components$TreeNodeView;

    public abstract INodeRenderFactory getNodeRenderFactoryParameter();

    public abstract Boolean getShowNodeImages();

    public TreeNodeView() {
        this.initialize();
    }

    private void initialize() {
        this.m_objNodeState = null;
        this.m_objShowNodeImages = null;
        this.m_objNodeRenderFactory = null;
        this.m_objMakeNodeDirect = null;
        this.m_CurrentForeachConnectImageValue = 2;
    }

    public IRender getCurrentRenderer() {
        INodeRenderFactory objRenderFactory = this.getNodeRenderFactory();
        ITreeRowSource objTreeRowSource = this.getTreeRowSource();
        return objRenderFactory.getRender(objTreeRowSource.getTreeRow().getTreeNode(), this.getTreeModelSource(), this.getPage().getRequestCycle());
    }

    public Object[] getNodeContext() {
        ITreeModelSource objModelSource = this.getTreeModelSource();
        ComponentAddress objModelSourceAddress = new ComponentAddress((IComponent)objModelSource);
        ITreeRowSource objTreeRowSource = this.getTreeRowSource();
        TreeRowObject objTreeRowObject = objTreeRowSource.getTreeRow();
        Object objValueUID = objTreeRowObject.getTreeNodeUID();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getNodeContext objValueUID = " + objValueUID));
        }
        return new Object[]{objValueUID, new Boolean(this.isNodeOpen()), objModelSourceAddress};
    }

    public void nodeExpandCollaps(IRequestCycle cycle) {
        ComponentAddress objModelSourceAddress;
        ITreeModelSource objTreeModelSource;
        ITreeStateModel objStateModel;
        boolean bState;
        Object[] context = cycle.getListenerParameters();
        Object objValueUID = null;
        if (context != null && context.length > 0) {
            objValueUID = context[0];
        }
        if (bState = (objStateModel = (objTreeModelSource = (ITreeModelSource)(objModelSourceAddress = (ComponentAddress)context[2]).findComponent(cycle)).getTreeModel().getTreeStateModel()).isUniqueKeyExpanded(objValueUID)) {
            objStateModel.collapse(objValueUID);
            this.fireNodeCollapsed(objValueUID, objTreeModelSource);
        } else {
            objStateModel.expandPath(objValueUID);
            this.fireNodeExpanded(objValueUID, objTreeModelSource);
        }
    }

    public void nodeSelect(IRequestCycle cycle) {
        ComponentAddress objModelSourceAddress;
        ITreeModelSource objTreeModelSource;
        ITreeStateModel objStateModel;
        Object objSelectedNodeInState;
        Object[] context = cycle.getListenerParameters();
        Object objValueUID = null;
        if (context != null && context.length > 0) {
            objValueUID = context[0];
        }
        if (objValueUID.equals(objSelectedNodeInState = (objStateModel = (objTreeModelSource = (ITreeModelSource)(objModelSourceAddress = (ComponentAddress)context[2]).findComponent(cycle)).getTreeModel().getTreeStateModel()).getSelectedNode())) {
            return;
        }
        objStateModel.setSelectedNode(objValueUID);
        this.fireNodeSelected(objValueUID, objTreeModelSource);
    }

    private void fireNodeSelected(Object objValueUID, ITreeModelSource objTreeModelSource) {
        this.deliverEvent(1, objValueUID, objTreeModelSource);
    }

    private void fireNodeCollapsed(Object objValueUID, ITreeModelSource objTreeModelSource) {
        this.deliverEvent(4, objValueUID, objTreeModelSource);
    }

    private void fireNodeExpanded(Object objValueUID, ITreeModelSource objTreeModelSource) {
        this.deliverEvent(2, objValueUID, objTreeModelSource);
    }

    private void deliverEvent(int nEventUID, Object objValueUID, ITreeModelSource objTreeModelSource) {
        ITreeStateListener objListener = objTreeModelSource.getTreeStateListener();
        if (objListener != null) {
            TreeStateEvent objEvent = new TreeStateEvent(nEventUID, objValueUID, objTreeModelSource.getTreeModel().getTreeStateModel());
            objListener.treeStateChanged(objEvent);
        }
    }

    public void pageDetached(PageEvent arg0) {
        this.initialize();
    }

    public void finishLoad(IRequestCycle objCycle, IPageLoader arg0, ComponentSpecification arg1) {
        super.finishLoad(objCycle, arg0, (IComponentSpecification)arg1);
        this.getPage().addPageDetachListener((PageDetachListener)this);
        this.m_objOpenNodeImage = this.getAsset("_openNodeImage");
        this.m_objCloseNodeImage = this.getAsset("_closeNodeImage");
    }

    public boolean isNodeOpen() {
        if (this.m_objNodeState == null) {
            ITreeRowSource objTreeRowSource = this.getTreeRowSource();
            TreeRowObject objTreeRowObject = objTreeRowSource.getTreeRow();
            Object objValueUID = objTreeRowObject.getTreeNodeUID();
            ITreeModelSource objTreeModelSource = this.getTreeModelSource();
            ITreeStateModel objStateModel = objTreeModelSource.getTreeModel().getTreeStateModel();
            boolean bState = objStateModel.isUniqueKeyExpanded(objValueUID);
            this.m_objNodeState = new Boolean(bState);
        }
        return this.m_objNodeState;
    }

    public IAsset getNodeImage() {
        IAsset objResult = null;
        ITreeRowSource objRowSource = this.getTreeRowSource();
        boolean bLeaf = objRowSource.getTreeRow().getLeaf();
        int nRowType = objRowSource.getTreeRow().getTreeRowPossiotionType();
        if (!bLeaf) {
            if (this.isNodeOpen()) {
                switch (nRowType) {
                    case 4: {
                        objResult = this.getAsset("_topLastOpenNodeImage");
                        break;
                    }
                    case 1: {
                        objResult = this.getAsset("_topOpenNodeImage");
                        break;
                    }
                    case 2: {
                        objResult = this.getAsset("_middleOpenNodeImage");
                        break;
                    }
                    case 3: {
                        objResult = this.getAsset("_bottomOpenNodeImage");
                        break;
                    }
                    default: {
                        objResult = this.getAsset("_openNodeImage");
                        break;
                    }
                }
            } else {
                switch (nRowType) {
                    case 4: {
                        objResult = this.getAsset("_topLastCloseNodeImage");
                        break;
                    }
                    case 1: {
                        objResult = this.getAsset("_topCloseNodeImage");
                        break;
                    }
                    case 2: {
                        objResult = this.getAsset("_middleCloseNodeImage");
                        break;
                    }
                    case 3: {
                        objResult = this.getAsset("_bottomCloseNodeImage");
                        break;
                    }
                    default: {
                        objResult = this.getAsset("_closeNodeImage");
                        break;
                    }
                }
            }
        } else {
            switch (nRowType) {
                case 4: {
                    objResult = this.getAsset("_topLineImage");
                    break;
                }
                case 1: {
                    objResult = this.getAsset("_topLineImage");
                    break;
                }
                case 2: {
                    objResult = this.getAsset("_middleCrossLineImage");
                    break;
                }
                case 3: {
                    objResult = this.getAsset("_bottomLineImage");
                    break;
                }
                default: {
                    objResult = this.getAsset("_bottomLineImage");
                }
            }
        }
        return objResult;
    }

    public IAsset getNodeImageOld() {
        if (this.isNodeOpen()) {
            if (this.m_objOpenNodeImage == null) {
                this.m_objOpenNodeImage = this.getAsset("_openNodeImage");
            }
            return this.m_objOpenNodeImage;
        }
        if (this.m_objCloseNodeImage == null) {
            this.m_objCloseNodeImage = this.getAsset("_closeNodeImage");
        }
        return this.m_objCloseNodeImage;
    }

    public IAsset getCloseNodeImage() {
        return this.m_objCloseNodeImage;
    }

    public IAsset getOpenNodeImage() {
        return this.m_objOpenNodeImage;
    }

    public void setCloseNodeImage(IAsset closeNodeImage) {
        this.m_objCloseNodeImage = closeNodeImage;
    }

    public void setOpenNodeImage(IAsset openNodeImage) {
        this.m_objOpenNodeImage = openNodeImage;
    }

    protected void renderComponent(IMarkupWriter arg0, IRequestCycle arg1) {
        super.renderComponent(arg0, arg1);
        this.m_objNodeState = null;
    }

    public Boolean isShowNodeImages() {
        if (this.m_objShowNodeImages == null) {
            this.m_objShowNodeImages = this.isParameterBound("nodeRenderFactory") ? this.getShowNodeImages() : Boolean.TRUE;
        }
        return this.m_objShowNodeImages;
    }

    public boolean getShowImages() {
        boolean bResult = this.isShowNodeImages();
        return bResult;
    }

    public boolean getShowWithoutImages() {
        boolean bResult = this.isShowNodeImages() == false;
        return bResult;
    }

    public String getOffsetStyle() {
        ITreeRowSource objTreeRowSource = this.getTreeRowSource();
        TreeRowObject objTreeRowObject = objTreeRowSource.getTreeRow();
        int nTreeRowDepth = 0;
        if (objTreeRowObject != null && (nTreeRowDepth = objTreeRowObject.getTreeRowDepth()) != 0) {
            --nTreeRowDepth;
        }
        return "padding-left: " + nTreeRowDepth * 19 + "px";
    }

    public INodeRenderFactory getNodeRenderFactory() {
        if (this.m_objNodeRenderFactory == null) {
            this.m_objNodeRenderFactory = this.isParameterBound("nodeRenderFactory") ? this.getNodeRenderFactoryParameter() : new SimpleNodeRenderFactory();
        }
        return this.m_objNodeRenderFactory;
    }

    public abstract boolean getMakeNodeDirect();

    public boolean getMakeNodeNoDirect() {
        return !this.getMakeNodeDirect();
    }

    public String getCleanSelectedID() {
        return this.getSelectedNodeID();
    }

    public String getSelectedID() {
        Object objSelectedNode;
        ITreeRowSource objTreeRowSource = this.getTreeRowSource();
        ITreeModelSource objTreeModelSource = this.getTreeModelSource();
        TreeRowObject objTreeRowObject = objTreeRowSource.getTreeRow();
        Object objNodeValueUID = objTreeRowObject.getTreeNodeUID();
        if (objNodeValueUID.equals(objSelectedNode = objTreeModelSource.getTreeModel().getTreeStateModel().getSelectedNode())) {
            return this.getSelectedNodeID();
        }
        return "";
    }

    private String getSelectedNodeID() {
        return "tree";
    }

    public String getNodeStyleClass() {
        ITreeRowSource objTreeRowSource = this.getTreeRowSource();
        ITreeModelSource objTreeModelSource = this.getTreeModelSource();
        TreeRowObject objTreeRowObject = objTreeRowSource.getTreeRow();
        boolean bResult = false;
        if (objTreeRowObject != null) {
            Object objNodeValueUID = objTreeRowObject.getTreeNodeUID();
            Object objSelectedNode = objTreeModelSource.getTreeModel().getTreeStateModel().getSelectedNode();
            bResult = objNodeValueUID.equals(objSelectedNode);
        }
        if (bResult) {
            return "selectedNodeViewClass";
        }
        return "notSelectedNodeViewClass";
    }

    public ITreeRowSource getTreeRowSource() {
        ITreeRowSource objSource = (ITreeRowSource)this.getPage().getRequestCycle().getAttribute("org.apache.tapestry.contrib.tree.model.ITreeRowSource");
        return objSource;
    }

    public ITreeModelSource getTreeModelSource() {
        ITreeModelSource objSource = (ITreeModelSource)this.getPage().getRequestCycle().getAttribute("org.apache.tapestry.contrib.tree.model.ITreeModelSource");
        return objSource;
    }

    public boolean getShowConnectImage() {
        ITreeRowSource objRowSource = this.getTreeRowSource();
        int nRowType = objRowSource.getTreeRow().getTreeRowPossiotionType();
        return 2 == nRowType;
    }

    public int[] getForeachConnectImageList() {
        ITreeRowSource objTreeRowSource = this.getTreeRowSource();
        TreeRowObject objTreeRowObject = objTreeRowSource.getTreeRow();
        return objTreeRowObject.getLineConnImages();
    }

    public boolean getDisableLink() {
        ITreeRowSource objRowSource = this.getTreeRowSource();
        boolean bLeaf = objRowSource.getTreeRow().getLeaf();
        return bLeaf;
    }

    public IAsset getConnectImage() {
        IAsset objResult = null;
        int nConnectImageType = this.getCurrentForeachConnectImageValue();
        switch (nConnectImageType) {
            case 1: {
                objResult = this.getAsset("_whiteSpaceImage");
                break;
            }
            case 2: {
                objResult = this.getAsset("_middleLineImage");
                break;
            }
            default: {
                objResult = this.getAsset("_whiteSpaceImage");
            }
        }
        return objResult;
    }

    public int getCurrentForeachConnectImageValue() {
        return this.m_CurrentForeachConnectImageValue;
    }

    public void setCurrentForeachConnectImageValue(int currentForeachConnectImageValue) {
        this.m_CurrentForeachConnectImageValue = currentForeachConnectImageValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

