/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.inspector;

import java.util.Iterator;
import java.util.Map;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IDirect;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.contrib.inspector.Inspector;
import org.apache.tapestry.engine.DirectServiceParameter;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.parse.CloseToken;
import org.apache.tapestry.parse.ComponentTemplate;
import org.apache.tapestry.parse.LocalizationToken;
import org.apache.tapestry.parse.OpenToken;
import org.apache.tapestry.parse.TemplateToken;
import org.apache.tapestry.parse.TextToken;
import org.apache.tapestry.parse.TokenType;
import org.apache.tapestry.services.TemplateSource;

public abstract class ShowTemplate
extends BaseComponent
implements IDirect {
    public abstract TemplateSource getTemplateSource();

    public boolean getHasTemplate() {
        Inspector inspector = (Inspector)this.getPage();
        return inspector.getInspectedComponent() instanceof BaseComponent;
    }

    public IRender getTemplateDelegate() {
        return new IRender(){

            public void render(IMarkupWriter writer, IRequestCycle cycle) {
                ShowTemplate.this.writeTemplate(writer, cycle);
            }
        };
    }

    private void writeTemplate(IMarkupWriter writer, IRequestCycle cycle) {
        IComponent inspectedComponent = this.getInspectedComponent();
        ComponentTemplate template = null;
        try {
            template = this.getTemplateSource().getTemplate(cycle, inspectedComponent);
        }
        catch (Exception ex) {
            return;
        }
        writer.begin("pre");
        int count = template.getTokenCount();
        for (int i = 0; i < count; ++i) {
            TemplateToken token = template.getToken(i);
            TokenType type = token.getType();
            if (type == TokenType.TEXT) {
                this.write(writer, (TextToken)token);
                continue;
            }
            if (type == TokenType.CLOSE) {
                this.write(writer, (CloseToken)token);
                continue;
            }
            if (token.getType() == TokenType.LOCALIZATION) {
                this.write(writer, (LocalizationToken)token);
                continue;
            }
            if (token.getType() != TokenType.OPEN) continue;
            boolean nextIsClose = i + 1 < count && template.getToken(i + 1).getType() == TokenType.CLOSE;
            this.write(writer, nextIsClose, (OpenToken)token);
            if (!nextIsClose) continue;
            ++i;
        }
        writer.end();
    }

    private IComponent getInspectedComponent() {
        Inspector page = (Inspector)this.getPage();
        return page.getInspectedComponent();
    }

    private void write(IMarkupWriter writer, TextToken token) {
        writer.print(token.getTemplateDataAsString());
    }

    private void write(IMarkupWriter writer, CloseToken token) {
        writer.begin("span");
        writer.attribute("class", "jwc-tag");
        writer.print("</");
        writer.print(token.getTag());
        writer.print(">");
        writer.end();
    }

    private void write(IMarkupWriter writer, LocalizationToken token) {
        IComponent component = this.getInspectedComponent();
        writer.begin("span");
        writer.attribute("class", "jwc-tag");
        writer.print("<span key=\"");
        writer.print(token.getKey());
        writer.print('\"');
        Map attributes = token.getAttributes();
        if (attributes != null && !attributes.isEmpty()) {
            Iterator it = attributes.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String attributeName = (String)entry.getKey();
                String attributeValue = (String)entry.getValue();
                writer.print(' ');
                writer.print(attributeName);
                writer.print("=\"");
                writer.print(attributeValue);
                writer.print('\"');
            }
        }
        writer.print('>');
        writer.begin("span");
        writer.attribute("class", "localized-string");
        writer.print(component.getMessages().getMessage(token.getKey()));
        writer.end();
        writer.print("</span>");
        writer.end();
    }

    private void write(IMarkupWriter writer, boolean nextIsClose, OpenToken token) {
        IComponent component = this.getInspectedComponent();
        IEngineService service = this.getPage().getEngine().getService("direct");
        String id = token.getId();
        IComponent embedded = component.getComponent(id);
        Object[] serviceParameters = new Object[]{embedded.getIdPath()};
        DirectServiceParameter dsp = new DirectServiceParameter((IDirect)this, serviceParameters);
        ILink link = service.getLink(this.getPage().getRequestCycle(), false, (Object)dsp);
        writer.begin("span");
        writer.attribute("class", "jwc-tag");
        writer.print("<");
        writer.print(token.getTag());
        writer.print(" jwcid=\"");
        writer.begin("span");
        writer.attribute("class", "jwc-id");
        writer.begin("a");
        writer.attribute("href", link.getURL());
        writer.print(id);
        writer.end();
        writer.end();
        writer.print('\"');
        Map attributes = token.getAttributesMap();
        if (attributes != null) {
            Iterator ii = attributes.entrySet().iterator();
            while (ii.hasNext()) {
                Map.Entry e = ii.next();
                String value = (String)e.getValue();
                writer.print(' ');
                writer.print(e.getKey().toString());
                writer.print("=\"");
                writer.print(value);
                writer.print('\"');
            }
        }
        if (nextIsClose) {
            writer.print('/');
        }
        writer.print('>');
        writer.end();
    }

    public void trigger(IRequestCycle cycle) {
        Inspector inspector = (Inspector)this.getPage();
        String componentId = (String)cycle.getListenerParameters()[0];
        inspector.selectComponent(componentId);
        IComponent newComponent = inspector.getInspectedComponent();
        if (!(newComponent instanceof BaseComponent)) {
            inspector.setView("SPECIFICATION");
        }
    }

    public boolean isStateful() {
        return true;
    }
}

