/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.model.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.contrib.table.model.ITableColumnModel;
import org.apache.tapestry.contrib.table.model.common.AbstractTableModel;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableState;
import org.apache.tapestry.contrib.table.model.sql.ISqlTableDataSource;
import org.apache.tapestry.contrib.table.model.sql.ResultSetIterator;
import org.apache.tapestry.contrib.table.model.sql.SqlTableColumnModel;

public class SqlTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$contrib$table$model$sql$SqlTableModel == null ? (class$org$apache$tapestry$contrib$table$model$sql$SqlTableModel = SqlTableModel.class$("org.apache.tapestry.contrib.table.model.sql.SqlTableModel")) : class$org$apache$tapestry$contrib$table$model$sql$SqlTableModel));
    private ISqlTableDataSource m_objDataSource;
    private SqlTableColumnModel m_objColumnModel;
    static /* synthetic */ Class class$org$apache$tapestry$contrib$table$model$sql$SqlTableModel;

    public SqlTableModel(ISqlTableDataSource objDataSource, SqlTableColumnModel objColumnModel) {
        this(objDataSource, objColumnModel, new SimpleTableState());
    }

    public SqlTableModel(ISqlTableDataSource objDataSource, SqlTableColumnModel objColumnModel, SimpleTableState objState) {
        super(objState);
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (Exception e) {
            System.out.println("ERROR: failed to load HSQLDB JDBC driver.");
            e.printStackTrace();
        }
        this.m_objDataSource = objDataSource;
        this.m_objColumnModel = objColumnModel;
    }

    public ITableColumnModel getColumnModel() {
        return this.m_objColumnModel;
    }

    public SqlTableColumnModel getSqlColumnModel() {
        return this.m_objColumnModel;
    }

    public Iterator getCurrentPageRows() {
        try {
            ResultSet objResultSet = this.getSqlDataSource().getCurrentRows(this.getSqlColumnModel(), this.getState());
            return new ResultSetIterator(objResultSet){

                protected void notifyEnd() {
                    SqlTableModel.this.getSqlDataSource().closeResultSet(this.getResultSet());
                }
            };
        }
        catch (SQLException e) {
            LOG.error((Object)"Cannot get current page rows", (Throwable)e);
            return new ResultSetIterator(null);
        }
    }

    public ISqlTableDataSource getSqlDataSource() {
        return this.m_objDataSource;
    }

    protected int getRowCount() {
        try {
            return this.m_objDataSource.getRowCount();
        }
        catch (SQLException e) {
            LOG.error((Object)"Cannot get row count", (Throwable)e);
            return 1;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

