/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.model.simple;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.tapestry.contrib.table.model.CTableDataModelEvent;
import org.apache.tapestry.contrib.table.model.ITableColumn;
import org.apache.tapestry.contrib.table.model.ITableColumnModel;
import org.apache.tapestry.contrib.table.model.ITableDataModel;
import org.apache.tapestry.contrib.table.model.ITableDataModelListener;
import org.apache.tapestry.contrib.table.model.ITableSortingState;
import org.apache.tapestry.contrib.table.model.common.AbstractTableModel;
import org.apache.tapestry.contrib.table.model.common.ArrayIterator;
import org.apache.tapestry.contrib.table.model.common.ReverseComparator;
import org.apache.tapestry.contrib.table.model.simple.SimpleListTableDataModel;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableColumnModel;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableSortingState;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableState;

public class SimpleTableModel
extends AbstractTableModel
implements ITableDataModelListener {
    private static final long serialVersionUID = 1L;
    private ITableDataModel m_objDataModel = null;
    private Object[] m_arrRows = null;
    private ITableColumnModel m_objColumnModel = null;
    private SimpleTableSortingState m_objLastSortingState;

    public SimpleTableModel(Object[] arrData, ITableColumn[] arrColumns) {
        this(new SimpleListTableDataModel(arrData), (ITableColumnModel)new SimpleTableColumnModel(arrColumns));
    }

    public SimpleTableModel(Object[] arrData, ITableColumnModel objColumnModel) {
        this(new SimpleListTableDataModel(arrData), objColumnModel);
    }

    public SimpleTableModel(ITableDataModel objDataModel, ITableColumnModel objColumnModel) {
        this(objDataModel, objColumnModel, new SimpleTableState());
    }

    public SimpleTableModel(ITableDataModel objDataModel, ITableColumnModel objColumnModel, SimpleTableState objState) {
        super(objState);
        this.m_objColumnModel = objColumnModel;
        this.m_objLastSortingState = new SimpleTableSortingState();
        this.setDataModel(objDataModel);
    }

    public ITableColumnModel getColumnModel() {
        return this.m_objColumnModel;
    }

    public Iterator getCurrentPageRows() {
        this.sortRows();
        int nPageSize = this.getPagingState().getPageSize();
        if (nPageSize <= 0) {
            return new ArrayIterator(this.m_arrRows);
        }
        int nCurrentPage = this.getPagingState().getCurrentPage();
        int nFrom = nCurrentPage * nPageSize;
        int nTo = (nCurrentPage + 1) * nPageSize;
        return new ArrayIterator(this.m_arrRows, nFrom, nTo);
    }

    public int getRowCount() {
        this.updateRows();
        return this.m_arrRows.length;
    }

    private void updateRows() {
        if (this.m_arrRows != null) {
            return;
        }
        this.m_objLastSortingState = new SimpleTableSortingState();
        int nRowCount = this.m_objDataModel.getRowCount();
        Object[] arrRows = new Object[nRowCount];
        int i = 0;
        Iterator it = this.m_objDataModel.getRows();
        while (it.hasNext()) {
            arrRows[i++] = it.next();
        }
        this.m_arrRows = arrRows;
    }

    protected void sortRows() {
        this.updateRows();
        ITableSortingState objSortingState = this.getSortingState();
        String strSortColumn = objSortingState.getSortColumn();
        if (strSortColumn == null) {
            return;
        }
        boolean bSortOrder = objSortingState.getSortOrder();
        if (strSortColumn.equals(this.m_objLastSortingState.getSortColumn()) && this.m_objLastSortingState.getSortOrder() == bSortOrder) {
            return;
        }
        ITableColumn objColumn = this.getColumnModel().getColumn(strSortColumn);
        if (objColumn == null || !objColumn.getSortable()) {
            return;
        }
        Comparator objCmp = objColumn.getComparator();
        if (objCmp == null) {
            return;
        }
        if (bSortOrder) {
            objCmp = new ReverseComparator(objCmp);
        }
        Arrays.sort(this.m_arrRows, objCmp);
        this.m_objLastSortingState.setSortColumn(strSortColumn, bSortOrder);
    }

    public void tableDataChanged(CTableDataModelEvent objEvent) {
        this.m_arrRows = null;
    }

    public ITableDataModel getDataModel() {
        return this.m_objDataModel;
    }

    public void setDataModel(ITableDataModel dataModel) {
        if (this.m_objDataModel != null) {
            this.m_objDataModel.removeTableDataModelListener(this);
        }
        this.m_objDataModel = dataModel;
        this.m_objDataModel.addTableDataModelListener(this);
        this.m_arrRows = null;
    }
}

