/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.form;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.contrib.form.CheckBoxMultiplePropertySelectionRenderer;
import org.apache.tapestry.contrib.form.IMultiplePropertySelectionRenderer;
import org.apache.tapestry.form.AbstractRequirableField;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.ValidationStrings;
import org.apache.tapestry.valid.ValidatorException;

public abstract class MultiplePropertySelection
extends AbstractRequirableField {
    public static final IMultiplePropertySelectionRenderer DEFAULT_CHECKBOX_RENDERER = new CheckBoxMultiplePropertySelectionRenderer();

    public abstract List getSelectedList();

    public abstract void setSelectedList(List var1);

    protected void finishLoad() {
        this.setRenderer(DEFAULT_CHECKBOX_RENDERER);
        this.setRequiredMessage(ValidationStrings.getMessagePattern((String)"select-field-is-required", (Locale)this.getPage().getLocale()));
    }

    public String getSubmittedValue(IRequestCycle cycle) {
        return super.getSubmittedValue(cycle);
    }

    protected void renderFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        super.renderFormComponent(writer, cycle);
    }

    protected void rewindFormComponent(IMarkupWriter writer, IRequestCycle cycle) {
        super.rewindFormComponent(writer, cycle);
    }

    public void bind(IMarkupWriter writer, IRequestCycle cycle) throws ValidatorException {
        String[] optionValues = cycle.getParameters(this.getName());
        IPropertySelectionModel model = this.getModel();
        ArrayList<Object> selectedList = new ArrayList<Object>(this.getModel().getOptionCount());
        if (optionValues != null) {
            for (int i = 0; i < optionValues.length; ++i) {
                Object selectedValue = model.translateValue(optionValues[i]);
                selectedList.add(selectedValue);
            }
        }
        this.setSelectedList(selectedList);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        List selectedList = this.getSelectedList();
        if (selectedList == null) {
            throw Tapestry.createRequiredParameterException((IComponent)this, (String)"selectedList");
        }
        IPropertySelectionModel model = this.getModel();
        if (model == null) {
            throw Tapestry.createRequiredParameterException((IComponent)this, (String)"model");
        }
        IMultiplePropertySelectionRenderer renderer = this.getRenderer();
        renderer.beginRender(this, writer, cycle);
        int count = model.getOptionCount();
        for (int i = 0; i < count; ++i) {
            Object option = model.getOption(i);
            boolean optionSelected = selectedList.contains(option);
            renderer.renderOption(this, writer, cycle, model, option, i, optionSelected);
        }
        renderer.endRender(this, writer, cycle);
    }

    public abstract IPropertySelectionModel getModel();

    public abstract IMultiplePropertySelectionRenderer getRenderer();

    public abstract void setRenderer(IMultiplePropertySelectionRenderer var1);
}

