/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.ajax;

import java.util.HashMap;
import java.util.Map;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.contrib.ajax.IXTile;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.services.LinkFactory;

public abstract class XTile
extends BaseComponent
implements IXTile {
    public abstract LinkFactory getLinkFactory();

    public abstract IActionListener getListener();

    public abstract String getSendName();

    public abstract String getReceiveName();

    public abstract String getErrorName();

    public abstract boolean getDisableCaching();

    public void trigger(IRequestCycle cycle) {
        IActionListener listener = this.getListener();
        if (listener == null) {
            throw Tapestry.createRequiredParameterException((IComponent)this, (String)"listener");
        }
        listener.actionTriggered((IComponent)this, cycle);
    }

    public Map getScriptSymbols() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("sendFunctionName", this.getSendName());
        ret.put("receiveFunctionName", this.getReceiveName());
        ret.put("errorFunctionName", this.getErrorName());
        ret.put("disableCaching", this.getDisableCaching() ? "true" : null);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("service", "xtile");
        parameters.put("page", this.getPage().getPageName());
        parameters.put("component", this.getIdPath());
        ILink link = this.getLinkFactory().constructLink(this.getPage().getRequestCycle(), false, parameters, false);
        ret.put("url", link.getURL());
        return ret;
    }
}

