/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.form;

import java.io.IOException;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.HiveMind;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.listener.ListenerInvoker;
import org.apache.tapestry.services.DataSqueezer;

public abstract class FormConditional
extends AbstractFormComponent {
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IForm form = this.getForm(cycle);
        boolean cycleRewinding = cycle.isRewinding();
        if (cycleRewinding && !form.isRewinding()) {
            return;
        }
        String name = form.getElementId((IFormComponent)this);
        boolean condition = this.getCondition(cycle, form, name);
        this.getListenerInvoker().invokeListener(this.getListener(), (IComponent)this, cycle);
        if (condition) {
            boolean render;
            String element = this.getElement();
            boolean bl = render = !cycleRewinding && HiveMind.isNonBlank((String)element);
            if (render) {
                writer.begin(element);
                this.renderInformalParameters(writer, cycle);
            }
            this.renderBody(writer, cycle);
            if (render) {
                writer.end(element);
            }
        }
    }

    private boolean getCondition(IRequestCycle cycle, IForm form, String name) {
        boolean condition;
        if (!cycle.isRewinding()) {
            condition = this.getCondition();
            this.writeValue(form, name, condition);
        } else {
            String submittedCondition = cycle.getParameter(name);
            condition = this.convertValue(submittedCondition);
        }
        if (this.isParameterBound("conditionValue")) {
            this.setConditionValue(condition);
        }
        return condition;
    }

    private void writeValue(IForm form, String name, boolean value) {
        String externalValue;
        try {
            externalValue = this.getDataSqueezer().squeeze((Object)(value ? Boolean.TRUE : Boolean.FALSE));
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"FormConditional.unable-to-convert-value", (Object)Boolean.toString(value)), (Object)this, null, (Throwable)ex);
        }
        form.addHiddenValue(name, externalValue);
    }

    private boolean convertValue(String value) {
        try {
            Boolean b = (Boolean)this.getDataSqueezer().unsqueeze(value);
            return b;
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"FormConditional.unable-to-convert-string", (Object)value), (Object)this, null, (Throwable)ex);
        }
    }

    public abstract DataSqueezer getDataSqueezer();

    public boolean isDisabled() {
        return false;
    }

    public abstract boolean getCondition();

    public abstract void setConditionValue(boolean var1);

    public abstract String getElement();

    public abstract IActionListener getListener();

    public abstract ListenerInvoker getListenerInvoker();
}

