/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.table.model.common;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.tapestry.contrib.table.model.ITableColumnModel;
import org.apache.tapestry.contrib.table.model.ITableModel;
import org.apache.tapestry.contrib.table.model.ITablePagingState;
import org.apache.tapestry.contrib.table.model.ITableSortingState;
import org.apache.tapestry.contrib.table.model.simple.SimpleTableState;

public abstract class AbstractTableModel
implements ITableModel,
Serializable {
    private SimpleTableState m_objTableState;

    protected AbstractTableModel() {
        this(new SimpleTableState());
    }

    protected AbstractTableModel(SimpleTableState objTableState) {
        this.m_objTableState = objTableState;
    }

    public ITablePagingState getPagingState() {
        return this.getState().getPagingState();
    }

    public ITableSortingState getSortingState() {
        return this.getState().getSortingState();
    }

    public SimpleTableState getState() {
        return this.m_objTableState;
    }

    protected abstract int getRowCount();

    public int getPageCount() {
        int nRowCount = this.getRowCount();
        if (nRowCount == 0) {
            return 1;
        }
        int nPageSize = this.getPagingState().getPageSize();
        if (nPageSize <= 0) {
            return 1;
        }
        return (nRowCount - 1) / nPageSize + 1;
    }

    public abstract Iterator getCurrentPageRows();

    public abstract ITableColumnModel getColumnModel();
}

