/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.inspector;

import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.contrib.inspector.Inspector;
import org.apache.tapestry.contrib.inspector.View;

public abstract class ViewTabs
extends BaseComponent {
    private static View[] _views = new View[]{View.SPECIFICATION, View.TEMPLATE, View.PROPERTIES, View.ENGINE};

    public View[] getViews() {
        return _views;
    }

    public abstract void setView(View var1);

    public abstract View getView();

    private IAsset getImageForView(boolean focus) {
        Inspector inspector = (Inspector)this.getPage();
        View view = this.getView();
        boolean selected = view == inspector.getView();
        StringBuffer buffer = new StringBuffer(view.getName());
        if (selected) {
            buffer.append("_selected");
        }
        if (focus) {
            buffer.append("_focus");
        }
        String key = buffer.toString();
        return (IAsset)this.getAssets().get(key);
    }

    public IAsset getViewImage() {
        return this.getImageForView(false);
    }

    public IAsset getFocusImage() {
        return this.getImageForView(true);
    }

    public IAsset getBannerImage() {
        Inspector inspector = (Inspector)this.getPage();
        View selectedView = inspector.getView();
        String key = selectedView.getName() + "_banner";
        return (IAsset)this.getAssets().get(key);
    }

    public void selectTab(IRequestCycle cycle) {
        Inspector inspector = (Inspector)this.getPage();
        inspector.setView(this.getView());
    }
}

