/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.inspector;

import java.util.HashMap;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Resource;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IDirect;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.contrib.inspector.Inspector;
import org.apache.tapestry.engine.DirectServiceParameter;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.html.Body;

public abstract class InspectorButton
extends BaseComponent
implements IDirect {
    private boolean _disabled = false;

    public void trigger(IRequestCycle cycle) {
        String name = this.getNamespace().constructQualifiedName("Inspector");
        Inspector inspector = (Inspector)cycle.getPage(name);
        inspector.inspect(this.getPage().getPageName(), cycle);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (this._disabled || cycle.isRewinding()) {
            return;
        }
        IEngine engine = this.getPage().getEngine();
        IScriptSource source = engine.getScriptSource();
        Resource scriptLocation = this.getSpecification().getSpecificationLocation().getRelativeResource("InspectorButton.script");
        IScript script = source.getScript(scriptLocation);
        HashMap<String, String> symbols = new HashMap<String, String>();
        IEngineService service = engine.getService("direct");
        ILink link = service.getLink(cycle, (Object)new DirectServiceParameter((IDirect)this));
        symbols.put("URL", link.getURL());
        Body body = Body.get((IRequestCycle)cycle);
        if (body == null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage((String)"InspectorButton.must-be-contained-by-body"), (Object)this, null, null);
        }
        script.execute(cycle, (IScriptProcessor)body, symbols);
        super.renderComponent(writer, cycle);
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        this._disabled = disabled;
    }

    public boolean isStateful() {
        return false;
    }
}

