/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.palette;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.components.Block;
import org.apache.tapestry.contrib.palette.PaletteColumn;
import org.apache.tapestry.contrib.palette.PaletteOption;
import org.apache.tapestry.contrib.palette.SortMode;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.form.Form;
import org.apache.tapestry.form.FormEventType;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.html.Body;
import org.apache.tapestry.request.RequestContext;
import org.apache.tapestry.valid.IValidationDelegate;

public abstract class Palette
extends BaseComponent
implements IFormComponent {
    private static final int DEFAULT_ROWS = 10;
    private static final int MAP_SIZE = 7;
    private static final String DEFAULT_TABLE_CLASS = "tapestry-palette";
    private Map _symbols;
    private IScript _script;

    public abstract void setAvailableColumn(PaletteColumn var1);

    public abstract void setSelectedColumn(PaletteColumn var1);

    protected void finishLoad() {
        this.setSelectedTitleBlock((Block)this.getComponent("defaultSelectedTitleBlock"));
        this.setAvailableTitleBlock((Block)this.getComponent("defaultAvailableTitleBlock"));
        this.setSelectImage(this.getAsset("Select"));
        this.setSelectDisabledImage(this.getAsset("SelectDisabled"));
        this.setDeselectImage(this.getAsset("Deselect"));
        this.setDeselectDisabledImage(this.getAsset("DeselectDisabled"));
        this.setUpImage(this.getAsset("Up"));
        this.setUpDisabledImage(this.getAsset("UpDisabled"));
        this.setDownImage(this.getAsset("Down"));
        this.setDownDisabledImage(this.getAsset("DownDisabled"));
        this.setTableClass(DEFAULT_TABLE_CLASS);
        this.setRows(10);
        this.setSort(SortMode.NONE);
    }

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract IForm getForm();

    public abstract void setForm(IForm var1);

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IForm form = Form.get((IRequestCycle)this.getPage().getRequestCycle());
        if (form == null) {
            throw new ApplicationRuntimeException("Palette component must be wrapped by a Form.", (Object)this, null, null);
        }
        this.setForm(form);
        IValidationDelegate delegate = form.getDelegate();
        if (delegate != null) {
            delegate.setFormComponent((IFormComponent)this);
        }
        this.setName(form.getElementId((IFormComponent)this));
        if (form.isRewinding()) {
            this.handleSubmission(cycle);
        }
        if (!cycle.isRewinding()) {
            this._symbols = new HashMap(7);
            this.runScript(cycle);
            form.addEventHandler(FormEventType.SUBMIT, (String)this._symbols.get("formSubmitFunctionName"));
            this.constructColumns();
        }
        super.renderComponent(writer, cycle);
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this._symbols = null;
        this.setAvailableColumn(null);
        this.setSelectedColumn(null);
        super.cleanupAfterRender(cycle);
    }

    private void runScript(IRequestCycle cycle) {
        Body body;
        if (this._script == null) {
            IEngine engine = this.getPage().getEngine();
            IScriptSource source = engine.getScriptSource();
            IResourceLocation scriptLocation = this.getSpecification().getSpecificationLocation().getRelativeLocation("Palette.script");
            this._script = source.getScript(scriptLocation);
        }
        if ((body = Body.get((IRequestCycle)cycle)) == null) {
            throw new ApplicationRuntimeException("Palette component must be wrapped by a Body.", (Object)this, null, null);
        }
        this.setImage(body, cycle, "selectImage", this.getSelectImage());
        this.setImage(body, cycle, "selectDisabledImage", this.getSelectDisabledImage());
        this.setImage(body, cycle, "deselectImage", this.getDeselectImage());
        this.setImage(body, cycle, "deselectDisabledImage", this.getDeselectDisabledImage());
        if (this.isSortUser()) {
            this.setImage(body, cycle, "upImage", this.getUpImage());
            this.setImage(body, cycle, "upDisabledImage", this.getUpDisabledImage());
            this.setImage(body, cycle, "downImage", this.getDownImage());
            this.setImage(body, cycle, "downDisabledImage", this.getDownDisabledImage());
        }
        this._symbols.put("palette", this);
        this._script.execute(cycle, (IScriptProcessor)body, this._symbols);
    }

    private void setImage(Body body, IRequestCycle cycle, String symbolName, IAsset asset) {
        String URL2 = asset.buildURL(cycle);
        String reference = body.getPreloadedImageReference(URL2);
        this._symbols.put(symbolName, reference);
    }

    public Map getSymbols() {
        return this._symbols;
    }

    private void constructColumns() {
        PaletteOption o;
        SortMode sortMode;
        List selected = this.getSelected();
        if (selected == null) {
            selected = Collections.EMPTY_LIST;
        }
        boolean sortUser = (sortMode = this.getSort()) == SortMode.USER;
        ArrayList<PaletteOption> selectedOptions = null;
        if (sortUser) {
            int count = selected.size();
            selectedOptions = new ArrayList<PaletteOption>(count);
            int i = 0;
            while (i < count) {
                selectedOptions.add(null);
                ++i;
            }
        }
        PaletteColumn availableColumn = new PaletteColumn((String)this._symbols.get("availableName"), this.getRows());
        PaletteColumn selectedColumn = new PaletteColumn(this.getName(), this.getRows());
        IPropertySelectionModel model = this.getModel();
        int count = model.getOptionCount();
        int i = 0;
        while (i < count) {
            boolean isSelected;
            Object optionValue = model.getOption(i);
            o = new PaletteOption(model.getValue(i), model.getLabel(i));
            int index = selected.indexOf(optionValue);
            boolean bl = isSelected = index >= 0;
            if (sortUser && isSelected) {
                selectedOptions.set(index, o);
            } else {
                PaletteColumn c = isSelected ? selectedColumn : availableColumn;
                c.addOption(o);
            }
            ++i;
        }
        if (sortUser) {
            Iterator i2 = selectedOptions.iterator();
            while (i2.hasNext()) {
                o = (PaletteOption)i2.next();
                selectedColumn.addOption(o);
            }
        }
        if (sortMode == SortMode.VALUE) {
            availableColumn.sortByValue();
            selectedColumn.sortByValue();
        } else if (sortMode == SortMode.LABEL) {
            availableColumn.sortByLabel();
            selectedColumn.sortByLabel();
        }
        this.setAvailableColumn(availableColumn);
        this.setSelectedColumn(selectedColumn);
    }

    private void handleSubmission(IRequestCycle cycle) {
        RequestContext context = cycle.getRequestContext();
        Object[] values = context.getParameters(this.getName());
        int count = Tapestry.size((Object[])values);
        if (count == 0) {
            return;
        }
        ArrayList<Object> selected = new ArrayList<Object>(count);
        IPropertySelectionModel model = this.getModel();
        int i = 0;
        while (i < count) {
            Object value = values[i];
            Object option = model.translateValue((String)value);
            selected.add(option);
            ++i;
        }
        this.setSelected(selected);
    }

    public boolean isSortUser() {
        return this.getSort() == SortMode.USER;
    }

    public String getDisplayName() {
        return null;
    }

    public abstract Block getAvailableTitleBlock();

    public abstract void setAvailableTitleBlock(Block var1);

    public abstract IAsset getDeselectDisabledImage();

    public abstract void setDeselectDisabledImage(IAsset var1);

    public abstract IAsset getDeselectImage();

    public abstract void setDeselectImage(IAsset var1);

    public abstract IAsset getDownDisabledImage();

    public abstract void setDownDisabledImage(IAsset var1);

    public abstract IAsset getDownImage();

    public abstract void setDownImage(IAsset var1);

    public abstract IPropertySelectionModel getModel();

    public abstract int getRows();

    public abstract void setRows(int var1);

    public abstract IAsset getSelectDisabledImage();

    public abstract void setSelectDisabledImage(IAsset var1);

    public abstract Block getSelectedTitleBlock();

    public abstract void setSelectedTitleBlock(Block var1);

    public abstract IAsset getSelectImage();

    public abstract void setSelectImage(IAsset var1);

    public abstract SortMode getSort();

    public abstract void setSort(SortMode var1);

    public abstract void setTableClass(String var1);

    public abstract IAsset getUpDisabledImage();

    public abstract void setUpDisabledImage(IAsset var1);

    public abstract IAsset getUpImage();

    public abstract void setUpImage(IAsset var1);

    public boolean isDisabled() {
        return false;
    }

    public abstract List getSelected();

    public abstract void setSelected(List var1);
}

