/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.contrib.form;

import java.io.IOException;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.request.RequestContext;
import org.apache.tapestry.util.io.DataSqueezer;

public abstract class FormConditional
extends AbstractFormComponent {
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        IForm form = this.getForm(cycle);
        boolean cycleRewinding = cycle.isRewinding();
        if (cycleRewinding && !form.isRewinding()) {
            return;
        }
        String name = form.getElementId((IFormComponent)this);
        boolean condition = this.getCondition(cycle, form, name);
        IActionListener listener = this.getListener();
        if (listener != null) {
            listener.actionTriggered((IComponent)this, cycle);
        }
        if (condition) {
            boolean render;
            String element = this.getElement();
            boolean bl = render = cycleRewinding && Tapestry.isNonBlank((String)element);
            if (render) {
                writer.begin(element);
                this.renderInformalParameters(writer, cycle);
            }
            this.renderBody(writer, cycle);
            if (render) {
                writer.end(element);
            }
        }
    }

    private boolean getCondition(IRequestCycle cycle, IForm form, String name) {
        boolean condition;
        if (!cycle.isRewinding()) {
            condition = this.getCondition();
            this.writeValue(form, name, condition);
        } else {
            RequestContext context = cycle.getRequestContext();
            String[] submittedConditions = context.getParameters(name);
            condition = this.convertValue(submittedConditions[0]);
        }
        IBinding conditionValueBinding = this.getConditionValueBinding();
        if (conditionValueBinding != null) {
            conditionValueBinding.setBoolean(condition);
        }
        return condition;
    }

    private void writeValue(IForm form, String name, boolean value) {
        String externalValue;
        Boolean booleanValue = new Boolean(value);
        try {
            externalValue = this.getDataSqueezer().squeeze((Object)booleanValue);
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"FormConditional.unable-to-convert-value", (Object)booleanValue), (Object)this, null, (Throwable)ex);
        }
        form.addHiddenValue(name, externalValue);
    }

    private boolean convertValue(String value) {
        try {
            Object booleanValue = this.getDataSqueezer().unsqueeze(value);
            return Tapestry.evaluateBoolean((Object)booleanValue);
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(Tapestry.format((String)"FormConditional.unable-to-convert-string", (Object)value), (Object)this, null, (Throwable)ex);
        }
    }

    private DataSqueezer getDataSqueezer() {
        return this.getPage().getEngine().getDataSqueezer();
    }

    public boolean isDisabled() {
        return false;
    }

    public abstract boolean getCondition();

    public abstract String getElement();

    public abstract IBinding getConditionValueBinding();

    public abstract IActionListener getListener();
}

