/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.annotations;

import java.lang.reflect.Method;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.annotations.AnnotationMessages;
import org.apache.tapestry.annotations.AnnotationUtils;
import org.apache.tapestry.annotations.Component;
import org.apache.tapestry.annotations.MethodAnnotationEnhancementWorker;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.spec.BindingSpecification;
import org.apache.tapestry.spec.BindingType;
import org.apache.tapestry.spec.ContainedComponent;
import org.apache.tapestry.spec.IBindingSpecification;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IContainedComponent;

public class ComponentAnnotationWorker
implements MethodAnnotationEnhancementWorker {
    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec, Method method) {
        Component component = method.getAnnotation(Component.class);
        String propertyName = AnnotationUtils.getPropertyName(method);
        ContainedComponent cc = new ContainedComponent();
        cc.setInheritInformalParameters(component.inheritInformalParameters());
        cc.setType(component.type());
        cc.setPropertyName(propertyName);
        for (String binding : component.bindings()) {
            this.addBinding((IContainedComponent)cc, binding);
        }
        String id = component.id();
        if (id.equals("")) {
            id = propertyName;
        }
        spec.addComponent(id, (IContainedComponent)cc);
    }

    void addBinding(IContainedComponent component, String binding) {
        int equalsx = binding.indexOf(61);
        if (equalsx < 1) {
            this.invalidBinding(binding);
        }
        if (equalsx + 1 >= binding.length()) {
            this.invalidBinding(binding);
        }
        String name = binding.substring(0, equalsx).trim();
        String value = binding.substring(equalsx + 1).trim();
        BindingSpecification bs = new BindingSpecification();
        bs.setType(BindingType.PREFIXED);
        bs.setValue(value);
        component.setBinding(name, (IBindingSpecification)bs);
    }

    private void invalidBinding(String binding) {
        throw new ApplicationRuntimeException(AnnotationMessages.bindingWrongFormat(binding));
    }
}

