/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.annotations;

import java.lang.reflect.Method;
import org.apache.hivemind.HiveMind;
import org.apache.tapestry.annotations.AnnotationUtils;
import org.apache.tapestry.annotations.Bean;
import org.apache.tapestry.annotations.MethodAnnotationEnhancementWorker;
import org.apache.tapestry.bean.IBeanInitializer;
import org.apache.tapestry.bean.LightweightBeanInitializer;
import org.apache.tapestry.enhance.EnhancementOperation;
import org.apache.tapestry.spec.BeanSpecification;
import org.apache.tapestry.spec.IBeanSpecification;
import org.apache.tapestry.spec.IComponentSpecification;

public class BeanAnnotationWorker
implements MethodAnnotationEnhancementWorker {
    public void performEnhancement(EnhancementOperation op, IComponentSpecification spec, Method method) {
        Bean bean = method.getAnnotation(Bean.class);
        String propertyName = AnnotationUtils.getPropertyName(method);
        Class beanClass = bean.value();
        if (beanClass.equals(Object.class)) {
            beanClass = op.getPropertyType(propertyName);
        }
        BeanSpecification bs = new BeanSpecification();
        bs.setClassName(beanClass.getName());
        bs.setPropertyName(propertyName);
        bs.setLifecycle(bean.lifecycle().getBeanLifecycle());
        String initializer = bean.initializer();
        if (HiveMind.isNonBlank((String)initializer)) {
            bs.addInitializer((IBeanInitializer)new LightweightBeanInitializer(initializer));
        }
        spec.addBeanSpecification(propertyName, (IBeanSpecification)bs);
    }
}

