/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.contrib.table.components.inserted;

import net.sf.tapestry.BaseComponent;
import net.sf.tapestry.ComponentAddress;
import net.sf.tapestry.IAsset;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.contrib.table.model.ITableModel;
import net.sf.tapestry.contrib.table.model.ITableModelSource;
import net.sf.tapestry.contrib.table.model.ITableSortingState;
import net.sf.tapestry.contrib.table.model.simple.ISimpleTableColumnRenderer;
import net.sf.tapestry.contrib.table.model.simple.SimpleTableColumn;
import net.sf.tapestry.event.PageDetachListener;
import net.sf.tapestry.event.PageEvent;

public class SimpleTableColumnComponent
extends BaseComponent
implements ISimpleTableColumnRenderer,
PageDetachListener {
    private SimpleTableColumn m_objColumn;
    private ITableModelSource m_objModelSource;

    public SimpleTableColumnComponent() {
        this.init();
    }

    public void pageDetached(PageEvent arg0) {
        this.init();
    }

    private void init() {
        this.m_objColumn = null;
        this.m_objModelSource = null;
    }

    protected void finishLoad() {
        super.finishLoad();
        this.getPage().addPageDetachListener((PageDetachListener)this);
    }

    public void initializeColumnRenderer(SimpleTableColumn objColumn, ITableModelSource objSource) {
        this.m_objColumn = objColumn;
        this.m_objModelSource = objSource;
    }

    public ITableModel getTableModel() {
        return this.m_objModelSource.getTableModel();
    }

    public boolean getColumnSorted() {
        return this.m_objColumn.getSortable();
    }

    public String getDisplayName() {
        return this.m_objColumn.getDisplayName();
    }

    public boolean getIsSorted() {
        ITableSortingState objSortingState = this.getTableModel().getSortingState();
        String strSortColumn = objSortingState.getSortColumn();
        return this.m_objColumn.getColumnName().equals(strSortColumn);
    }

    public IAsset getSortImage() {
        ITableSortingState objSortingState = this.getTableModel().getSortingState();
        if (!objSortingState.getSortOrder()) {
            return this.getAsset("sortUp");
        }
        return this.getAsset("sortDown");
    }

    public Object[] getColumnSelectedParameters() {
        return new Object[]{new ComponentAddress((IComponent)this.m_objModelSource), this.m_objColumn.getColumnName()};
    }

    public void columnSelected(IRequestCycle objCycle) {
        ComponentAddress objAddr;
        ITableModelSource objSource;
        ITableModel objModel;
        ITableSortingState objState;
        Object[] arrArgs = objCycle.getServiceParameters();
        String strColumnName = (String)arrArgs[1];
        if (strColumnName.equals((objState = (objModel = (objSource = (ITableModelSource)(objAddr = (ComponentAddress)arrArgs[0]).findComponent(objCycle)).getTableModel()).getSortingState()).getSortColumn())) {
            objState.setSortColumn(strColumnName, !objState.getSortOrder());
        } else {
            objState.setSortColumn(strColumnName, false);
        }
        objSource.fireObservedStateChange();
    }
}

