/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;

public class WrapperStartStopApp
implements WrapperListener,
Runnable {
    private Method m_startMainMethod;
    private String[] m_startMainArgs;
    private Method m_stopMainMethod;
    private boolean m_stopWait;
    private String[] m_stopMainArgs;
    private boolean m_mainComplete;
    private Integer m_mainExitCode;
    private boolean m_waitTimedOut;
    static /* synthetic */ Class array$Ljava$lang$String;

    private WrapperStartStopApp(Method startMainMethod, Method stopMainMethod, boolean stopWait, String[] stopMainArgs) {
        this.m_startMainMethod = startMainMethod;
        this.m_stopMainMethod = stopMainMethod;
        this.m_stopWait = stopWait;
        this.m_stopMainArgs = stopMainArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Throwable t;
        block13: {
            t = null;
            try {
                if (WrapperManager.isDebugEnabled()) {
                    System.out.println("WrapperStartStopApp: invoking start main method");
                }
                this.m_startMainMethod.invoke(null, new Object[]{this.m_startMainArgs});
                if (WrapperManager.isDebugEnabled()) {
                    System.out.println("WrapperStartStopApp: start main method completed");
                }
                WrapperStartStopApp wrapperStartStopApp = this;
                synchronized (wrapperStartStopApp) {
                    this.m_mainComplete = true;
                    this.notifyAll();
                }
                return;
            }
            catch (IllegalAccessException e) {
                t = e;
            }
            catch (IllegalArgumentException e) {
                t = e;
            }
            catch (InvocationTargetException e) {
                t = e.getTargetException();
                if (t != null) break block13;
                t = e;
            }
        }
        System.out.println();
        System.out.println("WrapperStartStopApp: Encountered an error running start main: " + t);
        t.printStackTrace();
        WrapperStartStopApp wrapperStartStopApp = this;
        synchronized (wrapperStartStopApp) {
            if (this.m_waitTimedOut) {
                WrapperManager.stop(1);
                return;
            }
            this.m_mainComplete = true;
            this.m_mainExitCode = new Integer(1);
            this.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer start(String[] args) {
        if (WrapperManager.isDebugEnabled()) {
            System.out.println("WrapperStartStopApp: start(args)");
        }
        Thread mainThread = new Thread((Runnable)this, "WrapperStartStopAppMain");
        WrapperStartStopApp wrapperStartStopApp = this;
        synchronized (wrapperStartStopApp) {
            this.m_startMainArgs = args;
            mainThread.start();
            try {
                this.wait(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.m_waitTimedOut = true;
            if (WrapperManager.isDebugEnabled()) {
                System.out.println("WrapperStartStopApp: start(args) end.  Main Completed=" + this.m_mainComplete + ", exitCode=" + this.m_mainExitCode);
            }
            return this.m_mainExitCode;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int stop(int exitCode) {
        if (WrapperManager.isDebugEnabled()) {
            System.out.println("WrapperStartStopApp: stop(" + exitCode + ")");
        }
        Exception t = null;
        try {
            if (WrapperManager.isDebugEnabled()) {
                System.out.println("WrapperStartStopApp: invoking stop main method");
            }
            this.m_stopMainMethod.invoke(null, new Object[]{this.m_stopMainArgs});
            if (WrapperManager.isDebugEnabled()) {
                System.out.println("WrapperStartStopApp: stop main method completed");
            }
            if (this.m_stopWait) {
                int threadCnt;
                while ((threadCnt = WrapperManager.getNonDaemonThreadCount()) > 1) {
                    if (WrapperManager.isDebugEnabled()) {
                        void var3_3;
                        System.out.println("WrapperStartStopApp: stopping.  Waiting for " + (int)(var3_3 - true) + " threads to complete.");
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            return exitCode;
        }
        catch (IllegalAccessException e) {
            t = e;
        }
        catch (IllegalArgumentException e) {
            t = e;
        }
        catch (InvocationTargetException e) {
            t = e;
        }
        System.out.println("Encountered an error running stop main: " + t);
        t.printStackTrace();
        return 1;
    }

    public void controlEvent(int event) {
        if (event == 202 && WrapperManager.isLaunchedAsService()) {
            if (WrapperManager.isDebugEnabled()) {
                System.out.println("WrapperStartStopApp: controlEvent(" + event + ") Ignored");
            }
        } else {
            if (WrapperManager.isDebugEnabled()) {
                System.out.println("WrapperStartStopApp: controlEvent(" + event + ") Stopping");
            }
            WrapperManager.stop(0);
        }
    }

    private static Method getMainMethod(String className) {
        Method mainMethod;
        Class<?> mainClass;
        try {
            mainClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            System.out.println("WrapperStartStopApp: Unable to locate the class " + className + ": " + e);
            WrapperStartStopApp.showUsage();
            WrapperManager.stop(1);
            return null;
        }
        catch (LinkageError e) {
            System.out.println("WrapperStartStopApp: Unable to locate the class " + className + ": " + e);
            WrapperStartStopApp.showUsage();
            WrapperManager.stop(1);
            return null;
        }
        try {
            mainMethod = mainClass.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = WrapperStartStopApp.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        }
        catch (NoSuchMethodException e) {
            System.out.println("WrapperStartStopApp: Unable to locate a public static main method in class " + className + ": " + e);
            WrapperStartStopApp.showUsage();
            WrapperManager.stop(1);
            return null;
        }
        catch (SecurityException e) {
            System.out.println("WrapperStartStopApp: Unable to locate a public static main method in class " + className + ": " + e);
            WrapperStartStopApp.showUsage();
            WrapperManager.stop(1);
            return null;
        }
        int modifiers = mainMethod.getModifiers();
        if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) {
            System.out.println("WrapperStartStopApp: The main method in class " + className + " must be declared public and static.");
            WrapperStartStopApp.showUsage();
            WrapperManager.stop(1);
            return null;
        }
        return mainMethod;
    }

    private static String[] getArgs(String[] args, int argBase) {
        int argCount;
        try {
            argCount = Integer.parseInt(args[argBase]);
        }
        catch (NumberFormatException e) {
            System.out.println("WrapperStartStopApp: Illegal argument count: " + args[argBase]);
            WrapperStartStopApp.showUsage();
            WrapperManager.stop(1);
            return null;
        }
        if (argCount < 0) {
            System.out.println("WrapperStartStopApp: Illegal argument count: " + args[argBase]);
            WrapperStartStopApp.showUsage();
            WrapperManager.stop(1);
            return null;
        }
        if (args.length < argBase + 1 + argCount) {
            System.out.println("WrapperStartStopApp: Not enough argments.  Argument count of " + argCount + " was specified.");
            System.out.println("( " + args.length + " < " + argBase + " + 2 + " + argCount + ")");
            WrapperStartStopApp.showUsage();
            WrapperManager.stop(1);
            return null;
        }
        String[] mainArgs = new String[argCount];
        System.arraycopy(args, argBase + 1, mainArgs, 0, argCount);
        return mainArgs;
    }

    private static void showUsage() {
        System.out.println();
        System.out.println("WrapperStartStopApp Usage:");
        System.out.println("  java org.tanukisoftware.wrapper.WrapperStartStopApp {start_class} {start_arg_count} [start_arguments] {stop_class} {stop_wait} {stop_arg_count} [stop_arguments]");
        System.out.println();
        System.out.println("Where:");
        System.out.println("  start_class:     The fully qualified class name to run to start the ");
        System.out.println("                   application.");
        System.out.println("  start_arg_count: The number of arguments to be passed to the start class's ");
        System.out.println("                   main method.");
        System.out.println("  stop_class:      The fully qualified class name to run to stop the ");
        System.out.println("                   application.");
        System.out.println("  stop_wait:       When stopping, should the Wrapper wait for all threads to ");
        System.out.println("                   complete before exiting (true/false).");
        System.out.println("  stop_arg_count:  The number of arguments to be passed to the stop class's ");
        System.out.println("                   main method.");
        System.out.println("  app_parameters:  The parameters that would normally be passed to the");
        System.out.println("                   application.");
    }

    public static void main(String[] args) {
        boolean stopWait;
        if (args.length < 5) {
            System.out.println("WrapperStartStopApp: Not enough argments.  Minimum 5 required.");
            WrapperStartStopApp.showUsage();
            WrapperManager.stop(1);
            return;
        }
        Method startMainMethod = WrapperStartStopApp.getMainMethod(args[0]);
        String[] startArgs = WrapperStartStopApp.getArgs(args, 1);
        int stopArgBase = 2 + startArgs.length;
        if (args.length < stopArgBase + 3) {
            System.out.println("WrapperStartStopApp: Not enough argments. Minimum 3 after start arguments.");
            WrapperStartStopApp.showUsage();
            WrapperManager.stop(1);
            return;
        }
        Method stopMainMethod = WrapperStartStopApp.getMainMethod(args[stopArgBase]);
        if (args[stopArgBase + 1].equalsIgnoreCase("true")) {
            stopWait = true;
        } else if (args[stopArgBase + 1].equalsIgnoreCase("false")) {
            stopWait = false;
        } else {
            System.out.println("WrapperStartStopApp: The stop_wait argument must be either true or false.");
            WrapperStartStopApp.showUsage();
            WrapperManager.stop(1);
            return;
        }
        String[] stopArgs = WrapperStartStopApp.getArgs(args, stopArgBase + 2);
        WrapperStartStopApp app = new WrapperStartStopApp(startMainMethod, stopMainMethod, stopWait, stopArgs);
        WrapperManager.start(app, startArgs);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

