/*
 * Decompiled with CFR 0.152.
 */
package manifold.util;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import manifold.util.JreUtil;
import manifold.util.ManExceptionUtil;
import manifold.util.ManifoldInitException;
import manifold.util.ReflectUtil;
import manifold.util.Unhelmeted;
import sun.misc.Unsafe;

public class JdkAccessUtil {
    private static Boolean useInternalUnsafe;

    public static Unhelmeted getUnhelmeted() {
        return Unhelmeted.getUnhelmeted();
    }

    public static void bypassJava9Security() {
        JdkAccessUtil.bypassJava9Security(true);
    }

    public static void bypassJava9Security(boolean fullJdk) {
        JdkAccessUtil.disableJava9IllegalAccessWarning();
        JdkAccessUtil.openModules(fullJdk);
    }

    public static void disableJava9IllegalAccessWarning() {
        JdkAccessUtil.disableJava9IllegalAccessWarning(JdkAccessUtil.class.getClassLoader());
        JdkAccessUtil.disableJava9IllegalAccessWarning(Thread.currentThread().getContextClassLoader());
    }

    public static void disableJava9IllegalAccessWarning(ClassLoader cl) {
        if (JreUtil.isJava8() || JreUtil.isJava17orLater()) {
            return;
        }
        try {
            Class<?> cls = Class.forName("jdk.internal.module.IllegalAccessLogger", false, cl);
            Field logger = cls.getDeclaredField("logger");
            JdkAccessUtil.getUnhelmeted().putObjectVolatile(cls, JdkAccessUtil.getUnhelmeted().staticFieldOffset(logger), null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void openModules(boolean fullJdk) {
        if (JreUtil.isJava8()) {
            return;
        }
        if (JdkAccessUtil.useInternalUnsafe()) {
            try {
                Class<?> tenderizeClass = Class.forName("manifold.util.Tenderizer");
                Object instance = tenderizeClass.getDeclaredField("INSTANCE").get(null);
                tenderizeClass.getDeclaredMethod("tenderize", new Class[0]).invoke(instance, new Object[0]);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        try {
            Class<?> classModule = ReflectUtil.type("java.lang.Module");
            ReflectUtil.MethodRef addExportsOrOpens = ReflectUtil.method(classModule, "implAddExportsOrOpens", String.class, classModule, Boolean.TYPE, Boolean.TYPE);
            Object thisModule = ReflectUtil.method(Class.class, "getModule", new Class[0]).invoke(JdkAccessUtil.class, new Object[0]);
            Object javaBase = ReflectUtil.method(Class.class, "getModule", new Class[0]).invoke(String.class, new Object[0]);
            addExportsOrOpens.invoke(javaBase, "jdk.internal.misc", thisModule, true, true);
            addExportsOrOpens.invoke(javaBase, "java.lang", thisModule, true, true);
            Object everyoneModule = ReflectUtil.field("java.lang.Module", "EVERYONE_MODULE").getStatic();
            JdkAccessUtil.openRuntimeModules(addExportsOrOpens, everyoneModule);
            if (fullJdk) {
                JdkAccessUtil.openCompilerModules(addExportsOrOpens, everyoneModule);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Error initializing Manifold", e);
        }
    }

    private static void openRuntimeModules(ReflectUtil.MethodRef addExportsOrOpens, Object manifoldModule) {
        Object javaBaseModule = ReflectUtil.method(Class.class, "getModule", new Class[0]).invoke(String.class, new Object[0]);
        Set packages = (Set)ReflectUtil.method(javaBaseModule, "getPackages", new Class[0]).invoke(new Object[0]);
        for (String pkg : packages) {
            addExportsOrOpens.invoke(javaBaseModule, pkg, manifoldModule, true, true);
        }
        Class<?> Desktop = ReflectUtil.type("java.awt.Desktop", true);
        if (Desktop == null) {
            return;
        }
        Object javaDesktop = ReflectUtil.method(Class.class, "getModule", new Class[0]).invoke(Desktop, new Object[0]);
        addExportsOrOpens.invoke(javaDesktop, "sun.awt", manifoldModule, true, true);
    }

    private static void openCompilerModules(ReflectUtil.MethodRef addExportsOrOpens, Object manifoldModule) {
        Object jdkCompilerModule = ReflectUtil.method(Class.class, "getModule", new Class[0]).invoke(ReflectUtil.type("com.sun.tools.javac.code.Symbol", true), new Object[0]);
        Set packages = (Set)ReflectUtil.method(jdkCompilerModule, "getPackages", new Class[0]).invoke(new Object[0]);
        for (String pkg : packages) {
            addExportsOrOpens.invoke(jdkCompilerModule, pkg, manifoldModule, true, true);
        }
        Class<?> HtmlDoclet = ReflectUtil.type("jdk.javadoc.internal.doclets.formats.html.HtmlDoclet", true);
        if (HtmlDoclet == null) {
            return;
        }
        Object jdkJavadoc = ReflectUtil.method(Class.class, "getModule", new Class[0]).invoke(HtmlDoclet, new Object[0]);
        addExportsOrOpens.invoke(jdkJavadoc, "jdk.javadoc.internal.doclets.formats.html", manifoldModule, true, true);
        addExportsOrOpens.invoke(jdkJavadoc, "jdk.javadoc.internal.tool", manifoldModule, true, true);
        if (!JreUtil.isJava13orLater()) {
            addExportsOrOpens.invoke(jdkJavadoc, "com.sun.tools.javadoc.main", manifoldModule, true, true);
            addExportsOrOpens.invoke(jdkJavadoc, "com.sun.tools.doclets.standard", manifoldModule, true, true);
        }
    }

    public static void openModule(Context context, String moduleName) {
        try {
            Symbol moduleToOpen = (Symbol)ReflectUtil.method(Symtab.instance(context), "getModule", Name.class).invoke(Names.instance(context).fromString(moduleName));
            if (moduleToOpen == null) {
                return;
            }
            moduleToOpen.complete();
            Set rootModules = (Set)ReflectUtil.field(ReflectUtil.method(ReflectUtil.type("com.sun.tools.javac.comp.Modules"), "instance", Context.class).invokeStatic(context), "allModules").get();
            for (Symbol rootModule : rootModules) {
                rootModule.complete();
                List requires = (List)ReflectUtil.field(rootModule, "requires").get();
                ArrayList<Object> newRequires = new ArrayList<Object>(requires);
                Object addedRequires = ReflectUtil.constructor("com.sun.tools.javac.code.Directive$RequiresDirective", ReflectUtil.type("com.sun.tools.javac.code.Symbol$ModuleSymbol")).newInstance(moduleToOpen);
                newRequires.add(addedRequires);
                requires = List.from(newRequires);
                ReflectUtil.field(rootModule, "requires").set(requires);
                ArrayList<Object> exports = new ArrayList<Object>((Collection)ReflectUtil.field(moduleToOpen, "exports").get());
                for (Symbol pkg : (Iterable)ReflectUtil.field(moduleToOpen, "enclosedPackages").get()) {
                    if (!(pkg instanceof Symbol.PackageSymbol)) continue;
                    Object exp = ReflectUtil.constructor("com.sun.tools.javac.code.Directive$ExportsDirective", Symbol.PackageSymbol.class, List.class).newInstance(pkg, List.of(rootModule));
                    exports.add(exp);
                    ((Map)ReflectUtil.field(rootModule, "visiblePackages").get()).put(((Symbol.PackageSymbol)pkg).fullname, pkg);
                }
                ReflectUtil.field(moduleToOpen, "exports").set(List.from(exports));
                Set readModules = (Set)ReflectUtil.field(moduleToOpen, "readModules").get();
                readModules.add(rootModule);
                ReflectUtil.field(moduleToOpen, "readModules").set(readModules);
            }
        }
        catch (Throwable e) {
            System.err.println("Failed to reflectively add-exports " + moduleName + "/* to root module[s], you must add the following argument to jave.exe:\n  --add-exports=" + moduleName + "/*=<root-module>\n");
            throw new RuntimeException(e);
        }
    }

    static boolean useInternalUnsafe() {
        if (useInternalUnsafe != null) {
            return useInternalUnsafe;
        }
        if (!JreUtil.isJava23orLater()) {
            useInternalUnsafe = false;
            return useInternalUnsafe;
        }
        try {
            Method getModule = Class.class.getMethod("getModule", new Class[0]);
            Object manifoldUtil = getModule.invoke(JdkAccessUtil.class, new Object[0]);
            Object javaBase = getModule.invoke(String.class, new Object[0]);
            boolean isJdkInternalAccessExported = (Boolean)javaBase.getClass().getMethod("isExported", String.class, javaBase.getClass()).invoke(javaBase, "jdk.internal.access", manifoldUtil);
            if (isJdkInternalAccessExported) {
                useInternalUnsafe = true;
                return useInternalUnsafe;
            }
        }
        catch (Throwable e) {
            throw ManExceptionUtil.unchecked(e);
        }
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            Unsafe unsafe = (Unsafe)theUnsafe.get(null);
            long offset = unsafe.staticFieldOffset(JdkAccessUtil.class.getDeclaredField("useInternalUnsafe"));
            if (offset >= 0L) {
                JdkAccessUtil.logWarningInstructions();
                useInternalUnsafe = false;
                return useInternalUnsafe;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JdkAccessUtil.logErrorInstructions();
        useInternalUnsafe = true;
        throw new ManifoldInitException();
    }

    private static void logErrorInstructions() {
        System.err.println("#  Manifold requires the following Java process option:\n#      --add-exports=java.base/jdk.internal.access=ALL-UNNAMED\n#  If you are using the Java Platform Module System (JPMS), use this instead:\n#      --add-exports=java.base/jdk.internal.access=manifold.util\n");
    }

    private static void logWarningInstructions() {
        if (!JreUtil.isJava24orLater()) {
            return;
        }
        java.util.List<String> values = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (values.stream().noneMatch(arg -> arg.contains("--sun-misc-unsafe-memory-access=allow"))) {
            System.err.println("#  To remove this warning add the following Java process option:\n#      --add-exports=java.base/jdk.internal.access=ALL-UNNAMED\n#  If you are using the Java Platform Module System (JPMS), use this instead:\n#      --add-exports=java.base/jdk.internal.access=manifold.util\n");
        }
    }
}

