/*
 * Decompiled with CFR 0.152.
 */
package manifold.util;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import manifold.util.ManExceptionUtil;
import manifold.util.NecessaryEvilUtil;
import manifold.util.concurrent.ConcurrentHashSet;
import manifold.util.concurrent.ConcurrentWeakHashMap;
import manifold.util.concurrent.LocklessLazyVar;

public class ReflectUtil {
    private static final ConcurrentWeakHashMap<Class, ConcurrentMap<String, ConcurrentHashSet<Method>>> _methodsByName = new ConcurrentWeakHashMap();
    private static final ConcurrentWeakHashMap<Class, ConcurrentMap<String, Field>> _fieldsByName = new ConcurrentWeakHashMap();
    private static final ConcurrentWeakHashMap<Class, Set<Constructor>> _constructorsByClass = new ConcurrentWeakHashMap();
    private static final LocklessLazyVar<ClassContextSecurityManager> _sm = LocklessLazyVar.make(() -> new ClassContextSecurityManager());

    public static Class<?> type(String fqn) {
        return ReflectUtil.type(fqn, false);
    }

    public static Class<?> type(String fqn, boolean useCallChain) {
        try {
            return Class.forName(fqn);
        }
        catch (ClassNotFoundException e) {
            return ReflectUtil.type(fqn, Thread.currentThread().getContextClassLoader(), useCallChain);
        }
    }

    public static Class<?> type(String fqn, ClassLoader cl) {
        return ReflectUtil.type(fqn, cl, false);
    }

    public static Class<?> type(String fqn, ClassLoader cl, boolean useCallChain) {
        try {
            return Class.forName(fqn, false, cl);
        }
        catch (ClassNotFoundException e) {
            return useCallChain ? ReflectUtil.findInCallChain(fqn) : null;
        }
    }

    private static Class<?> findInCallChain(String fqn) {
        Class[] stackTraceClasses = Objects.requireNonNull(_sm.get()).getClassContext();
        if (stackTraceClasses == null) {
            return null;
        }
        HashSet<ClassLoader> attempted = new HashSet<ClassLoader>();
        attempted.add(ReflectUtil.class.getClassLoader());
        attempted.add(Thread.currentThread().getContextClassLoader());
        for (Class cls : stackTraceClasses) {
            ClassLoader cl = cls.getClassLoader();
            if (attempted.contains(cl)) continue;
            attempted.add(cl);
            try {
                return Class.forName(fqn, false, cl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static LiveMethodRef method(Object receiver, String name, Class ... params) {
        LiveMethodRef liveRef = WithNull.method(receiver, name, params);
        if (liveRef == null) {
            throw new RuntimeException("Method '" + name + "' not found");
        }
        return liveRef;
    }

    public static MethodRef method(String fqn, String name, Class ... params) {
        return ReflectUtil.method(ReflectUtil.type(fqn), name, params);
    }

    public static MethodRef method(Class<?> cls, String name, Class ... params) {
        MethodRef match = ReflectUtil.matchFirstMethod(cls, name, params);
        if (match != null) {
            return match;
        }
        MethodRef mr = ReflectUtil.getMethodFromCache(cls, name, params);
        if (mr != null) {
            return mr;
        }
        try {
            Method method = cls.getDeclaredMethod(name, params);
            return ReflectUtil.addMethodToCache(cls, method);
        }
        catch (Exception e) {
            Class<?> superclass = cls.getSuperclass();
            if (superclass != null && (mr = ReflectUtil.method(superclass, name, params)) != null) {
                ReflectUtil.addMethodToCache(cls, mr._method);
                return mr;
            }
            for (Class<?> iface : cls.getInterfaces()) {
                mr = ReflectUtil.method(iface, name, params);
                if (mr == null) continue;
                ReflectUtil.addMethodToCache(cls, mr._method);
                return mr;
            }
            return null;
        }
    }

    private static MethodRef matchFirstMethod(Class<?> cls, String name, Class[] params) {
        if (name.indexOf(124) >= 0) {
            StringTokenizer tokenizer = new StringTokenizer(name, "|");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                MethodRef method = ReflectUtil.method(cls, token, params);
                if (method == null) continue;
                return method;
            }
        }
        return null;
    }

    public static LiveFieldRef field(Object receiver, String name) {
        LiveFieldRef liveRef = WithNull.field(receiver, name);
        if (liveRef == null) {
            throw new RuntimeException("Field '" + name + "' not found");
        }
        return liveRef;
    }

    public static FieldRef field(String fqn, String name) {
        return ReflectUtil.field(ReflectUtil.type(fqn), name);
    }

    public static FieldRef field(Class<?> cls, String name) {
        FieldRef match = ReflectUtil.matchFirstField(cls, name);
        if (match != null) {
            return match;
        }
        FieldRef fr = ReflectUtil.getFieldFromCache(cls, name);
        if (fr != null) {
            return fr;
        }
        try {
            Field field = cls.getDeclaredField(name);
            return ReflectUtil.addFieldToCache(cls, field);
        }
        catch (Exception e) {
            Class<?> superclass = cls.getSuperclass();
            if (superclass != null && (fr = ReflectUtil.field(superclass, name)) != null) {
                ReflectUtil.addFieldToCache(cls, fr._field);
                return fr;
            }
            for (Class<?> iface : cls.getInterfaces()) {
                fr = ReflectUtil.field(iface, name);
                if (fr == null) continue;
                ReflectUtil.addFieldToCache(cls, fr._field);
                return fr;
            }
            return null;
        }
    }

    private static FieldRef matchFirstField(Class<?> cls, String name) {
        if (name.indexOf(124) >= 0) {
            StringTokenizer tokenizer = new StringTokenizer(name, "|");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                FieldRef field = ReflectUtil.field(cls, token);
                if (field == null) continue;
                return field;
            }
        }
        return null;
    }

    public static ConstructorRef constructor(String fqn, Class<?> ... params) {
        return ReflectUtil.constructor(ReflectUtil.type(fqn), params);
    }

    public static ConstructorRef constructor(Class<?> cls, Class<?> ... params) {
        ConstructorRef mr = ReflectUtil.getConstructorFromCache(cls, params);
        if (mr != null) {
            return mr;
        }
        try {
            Constructor<?> constructor = cls.getDeclaredConstructor(params);
            return ReflectUtil.addConstructorToCache(cls, constructor);
        }
        catch (Exception e) {
            Class<?> superclass = cls.getSuperclass();
            if (superclass != null && (mr = ReflectUtil.constructor(superclass, params)) != null) {
                return mr;
            }
            for (Class<?> iface : cls.getInterfaces()) {
                mr = ReflectUtil.constructor(iface, params);
                if (mr == null) continue;
                ReflectUtil.addConstructorToCache(cls, mr._constructor);
                return mr;
            }
            return null;
        }
    }

    public static void setAccessible(Field f) {
        try {
            f.setAccessible(true);
        }
        catch (Exception e) {
            ReflectUtil.setAccessible((Member)f);
        }
    }

    public static void setAccessible(Method m) {
        try {
            m.setAccessible(true);
        }
        catch (Exception e) {
            ReflectUtil.setAccessible((Member)m);
        }
    }

    public static void setAccessible(Constructor c) {
        try {
            c.setAccessible(true);
        }
        catch (Exception e) {
            ReflectUtil.setAccessible((Member)c);
        }
    }

    public static void setAccessible(Member m) {
        Field overrideField = ReflectUtil.getOverrideField();
        try {
            NecessaryEvilUtil.getUnsafe().putObjectVolatile(m, NecessaryEvilUtil.getUnsafe().objectFieldOffset(overrideField), true);
        }
        catch (Exception e) {
            throw ManExceptionUtil.unchecked(e);
        }
    }

    private static Field getOverrideField() {
        Field overrideField = ReflectUtil.getRawFieldFromCache(AccessibleObject.class, "override");
        if (overrideField == null) {
            try {
                overrideField = AccessibleObject.class.getDeclaredField("override");
                ReflectUtil.addRawFieldToCache(AccessibleObject.class, overrideField);
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }
        return overrideField;
    }

    private static MethodRef addMethodToCache(Class cls, Method m) {
        ReflectUtil.setAccessible(m);
        ReflectUtil.addRawMethodToCache(cls, m);
        return new MethodRef(m);
    }

    private static void addRawMethodToCache(Class cls, Method m) {
        ConcurrentHashSet<Method> methods;
        ConcurrentMap<String, ConcurrentHashSet<Method>> methodsByName = _methodsByName.get(cls);
        if (methodsByName == null) {
            methodsByName = new ConcurrentHashMap<String, ConcurrentHashSet<Method>>();
            _methodsByName.put(cls, methodsByName);
        }
        if ((methods = (ConcurrentHashSet<Method>)methodsByName.get(m.getName())) == null) {
            methods = new ConcurrentHashSet<Method>(2);
            methodsByName.put(m.getName(), methods);
        }
        methods.add(m);
    }

    private static MethodRef getMethodFromCache(Class cls, String name, Class ... params) {
        Method m = ReflectUtil.getRawMethodFromCache(cls, name, params);
        if (m != null) {
            return new MethodRef(m);
        }
        return null;
    }

    private static Method getRawMethodFromCache(Class cls, String name, Class ... params) {
        ConcurrentHashSet methods;
        ConcurrentMap<String, ConcurrentHashSet<Method>> methodsByName = _methodsByName.get(cls);
        if (methodsByName != null && (methods = (ConcurrentHashSet)methodsByName.get(name)) != null) {
            block0: for (Method m : methods) {
                int paramsLen;
                int n = paramsLen = params == null ? 0 : params.length;
                if (m.getParameterCount() != paramsLen) continue;
                if (paramsLen > 0) {
                    Class<?>[] mparams = m.getParameterTypes();
                    for (int i = 0; i < mparams.length; ++i) {
                        Class<?> mparam = mparams[i];
                        if (!mparam.equals(params[i])) continue block0;
                    }
                }
                return m;
            }
        }
        return null;
    }

    private static ConstructorRef addConstructorToCache(Class cls, Constructor m) {
        ReflectUtil.setAccessible(m);
        ReflectUtil.addRawConstructorToCache(cls, m);
        return new ConstructorRef(m);
    }

    private static void addRawConstructorToCache(Class cls, Constructor m) {
        Set constructors = _constructorsByClass.computeIfAbsent(cls, k -> ConcurrentHashMap.newKeySet());
        constructors.add(m);
    }

    private static ConstructorRef getConstructorFromCache(Class cls, Class ... params) {
        Constructor ctor = ReflectUtil.getRawConstructorFromCache(cls, params);
        if (ctor != null) {
            return new ConstructorRef(ctor);
        }
        return null;
    }

    private static Constructor getRawConstructorFromCache(Class cls, Class ... params) {
        Set<Constructor> constructors = _constructorsByClass.get(cls);
        if (constructors != null) {
            block0: for (Constructor m : constructors) {
                int paramsLen;
                int n = paramsLen = params == null ? 0 : params.length;
                if (m.getParameterCount() != paramsLen) continue;
                Class<?>[] mparams = m.getParameterTypes();
                if (paramsLen > 0) {
                    for (int i = 0; i < mparams.length; ++i) {
                        Class<?> mparam = mparams[i];
                        if (!mparam.equals(params[i])) continue block0;
                    }
                }
                return m;
            }
        }
        return null;
    }

    private static boolean setFinal(Field field, Object value) {
        return ReflectUtil.setFinal(field, null, value);
    }

    private static boolean setFinal(Field field, Object ctx, Object value) {
        if (Modifier.isFinal(field.getModifiers())) {
            try {
                ReflectUtil.clearFieldAccessors(field);
                ReflectUtil.removeFinalModifier(field);
                field.set(ctx, value);
                return true;
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }
        return false;
    }

    private static void removeFinalModifier(Field field) throws Exception {
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
    }

    private static void clearFieldAccessors(Field field) throws Exception {
        Field fa = Field.class.getDeclaredField("fieldAccessor");
        fa.setAccessible(true);
        fa.set(field, null);
        Field ofa = Field.class.getDeclaredField("overrideFieldAccessor");
        ofa.setAccessible(true);
        ofa.set(field, null);
        Field rf = Field.class.getDeclaredField("root");
        rf.setAccessible(true);
        Field root = (Field)rf.get(field);
        if (root != null) {
            ReflectUtil.clearFieldAccessors(root);
        }
    }

    private static FieldRef addFieldToCache(Class cls, Field f) {
        ReflectUtil.setAccessible(f);
        ReflectUtil.addRawFieldToCache(cls, f);
        return new FieldRef(f);
    }

    private static FieldRef getFieldFromCache(Class cls, String name) {
        Field field = ReflectUtil.getRawFieldFromCache(cls, name);
        if (field != null) {
            return new FieldRef(field);
        }
        return null;
    }

    private static void addRawFieldToCache(Class cls, Field f) {
        ConcurrentMap<String, Field> fieldsByName = _fieldsByName.get(cls);
        if (fieldsByName == null) {
            fieldsByName = new ConcurrentHashMap<String, Field>();
            _fieldsByName.put(cls, fieldsByName);
        }
        fieldsByName.put(f.getName(), f);
    }

    private static Field getRawFieldFromCache(Class cls, String name) {
        ConcurrentMap<String, Field> fieldsByName = _fieldsByName.get(cls);
        if (fieldsByName != null) {
            return (Field)fieldsByName.get(name);
        }
        return null;
    }

    public static void preloadClassIntoParentLoader(String fqn, URI content, ClassLoader wouldBeLoader, ClassLoader parentLoader) {
        if (null != ReflectUtil.method(parentLoader, "findLoadedClass", String.class).invoke(fqn)) {
            return;
        }
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(content));
            ReflectUtil.method(parentLoader, "defineClass", byte[].class, Integer.TYPE, Integer.TYPE).invoke(bytes, 0, bytes.length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static class ClassContextSecurityManager
    extends SecurityManager {
        ClassContextSecurityManager() {
        }

        protected Class[] getClassContext() {
            return super.getClassContext();
        }
    }

    public static class WithNull {
        public static LiveMethodRef method(Object receiver, String name, Class ... params) {
            MethodRef ref = ReflectUtil.method(receiver.getClass(), name, params);
            if (ref == null) {
                return null;
            }
            return new LiveMethodRef(ref._method, receiver);
        }

        public static LiveFieldRef field(Object receiver, String name) {
            FieldRef ref = ReflectUtil.field(receiver.getClass(), name);
            if (ref == null) {
                return null;
            }
            return new LiveFieldRef(ref._field, receiver);
        }

        public static LiveMethodRef methodWithReturn(Object receiver, String name, Class<?> returnType, Class ... params) {
            LiveMethodRef ref = WithNull.method(receiver, name, params);
            if (ref != null && !returnType.isAssignableFrom(ref.getMethod().getReturnType())) {
                ref = null;
            }
            return ref;
        }
    }

    public static class ConstructorRef {
        private final Constructor<?> _constructor;

        private ConstructorRef(Constructor<?> constructor) {
            this._constructor = constructor;
        }

        public Object newInstance(Object ... args) {
            try {
                return this._constructor.newInstance(args);
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }
    }

    public static class LiveFieldRef {
        private final Field _field;
        private final Object _receiver;

        private LiveFieldRef(Field f, Object receiver) {
            this._field = f;
            this._receiver = receiver;
        }

        public Field getField() {
            return this._field;
        }

        public Object getReceiver() {
            return this._receiver;
        }

        public Object get() {
            try {
                return this._field.get(this._receiver);
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }

        public void set(Object value) {
            try {
                this._field.set(this._receiver, value);
            }
            catch (Exception e) {
                if (ReflectUtil.setFinal(this._field, this._receiver, value)) {
                    return;
                }
                throw ManExceptionUtil.unchecked(e);
            }
        }
    }

    public static class FieldRef {
        private final Field _field;

        private FieldRef(Field f) {
            this._field = f;
        }

        public Object get(Object receiver) {
            try {
                return this._field.get(receiver);
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }

        public void set(Object receiver, Object value) {
            try {
                this._field.set(receiver, value);
            }
            catch (Exception e) {
                if (ReflectUtil.setFinal(this._field, receiver, value)) {
                    return;
                }
                throw ManExceptionUtil.unchecked(e);
            }
        }

        public Object getStatic() {
            try {
                return this._field.get(null);
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }

        public void setStatic(Object value) {
            try {
                this._field.set(null, value);
            }
            catch (Exception e) {
                if (ReflectUtil.setFinal(this._field, value)) {
                    return;
                }
                throw ManExceptionUtil.unchecked(e);
            }
        }
    }

    public static class LiveMethodRef {
        private Method _method;
        private Object _receiver;

        private LiveMethodRef(Method m, Object receiver) {
            this._method = m;
            this._receiver = receiver;
        }

        public Method getMethod() {
            return this._method;
        }

        public Object getReceiver() {
            return this._receiver;
        }

        public Object invoke(Object ... args) {
            try {
                return this._method.invoke(this._receiver, args);
            }
            catch (InvocationTargetException ite) {
                throw ManExceptionUtil.unchecked(ite.getCause());
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }
    }

    public static class MethodRef {
        private final Method _method;

        private MethodRef(Method m) {
            this._method = m;
        }

        public Method getMethod() {
            return this._method;
        }

        public Object invoke(Object receiver, Object ... args) {
            try {
                return this._method.invoke(receiver, args);
            }
            catch (InvocationTargetException ite) {
                throw ManExceptionUtil.unchecked(ite.getCause());
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }

        public Object invokeStatic(Object ... args) {
            try {
                return this._method.invoke(null, args);
            }
            catch (InvocationTargetException ite) {
                throw ManExceptionUtil.unchecked(ite.getCause());
            }
            catch (Exception e) {
                throw ManExceptionUtil.unchecked(e);
            }
        }
    }
}

