/*
 * Decompiled with CFR 0.152.
 */
package manifold.util.concurrent;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import manifold.util.ILogger;

public class Cache<K, V> {
    private final String _name;
    private final int _size;
    private final CacheLoader<K, V> _loader;
    private LoadingCache<K, V> _cacheImpl;
    private ScheduledFuture<?> _loggingTask;

    public Cache(String name, int size, CacheLoader<K, V> loader) {
        this._name = name;
        this._size = size;
        this._loader = loader;
        this.clearCacheImpl();
    }

    private void clearCacheImpl() {
        this._cacheImpl = Caffeine.newBuilder().maximumSize((long)this._size).build(this._loader);
    }

    public void evict(K key) {
        this._cacheImpl.invalidate(key);
    }

    public void put(K key, V value) {
        this._cacheImpl.put(key, value);
    }

    public V get(K key) {
        return (V)this._cacheImpl.get(key);
    }

    public CacheStats getStats() {
        return this._cacheImpl.stats();
    }

    public String getName() {
        return this._name;
    }

    public synchronized Cache<K, V> logEveryNSeconds(int seconds, ILogger logger) {
        if (this._loggingTask != null) {
            throw new IllegalStateException("Logging for " + this + " is already enabled");
        }
        ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
        this._loggingTask = service.scheduleAtFixedRate(() -> logger.info(this), seconds, seconds, TimeUnit.SECONDS);
        return this;
    }

    public synchronized void stopLogging() {
        if (this._loggingTask != null) {
            this._loggingTask.cancel(false);
        }
    }

    public void clear() {
        this.clearCacheImpl();
    }

    public String toString() {
        return this.getStats().toString();
    }

    public static <KK, VV> Cache<KK, VV> make(String name, int size, CacheLoader<KK, VV> loader) {
        return new Cache<KK, VV>(name, size, loader);
    }
}

