/*
 * Decompiled with CFR 0.152.
 */
package manifold.util.concurrent;

import java.math.BigDecimal;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import manifold.util.ILogger;

public class Cache<K, V> {
    private ConcurrentSkipListMap<K, V> _cacheImlp;
    private final MissHandler<K, V> _missHandler;
    private final String _name;
    private final int _size;
    private final AtomicInteger _requests = new AtomicInteger();
    private final AtomicInteger _misses = new AtomicInteger();
    private final AtomicInteger _hits = new AtomicInteger();
    private ScheduledFuture<?> _loggingTask;

    public Cache(String name, int size, MissHandler<K, V> missHandler) {
        this._name = name;
        this._size = size;
        this.clearCacheImpl();
        this._missHandler = missHandler;
    }

    private void clearCacheImpl() {
        this._cacheImlp = new ConcurrentSkipListMap();
    }

    public V evict(K key) {
        return this._cacheImlp.remove(key);
    }

    public V put(K key, V value) {
        return this._cacheImlp.put(key, value);
    }

    public V get(K key) {
        V value = this._cacheImlp.get(key);
        this._requests.incrementAndGet();
        if (value == null) {
            value = this._missHandler.load(key);
            this._cacheImlp.put(key, value);
            this._misses.incrementAndGet();
        } else {
            this._hits.incrementAndGet();
        }
        return value;
    }

    public int getConfiguredSize() {
        return this._size;
    }

    public int getUtilizedSize() {
        return this._cacheImlp.size();
    }

    public int getRequests() {
        return this._requests.get();
    }

    public int getMisses() {
        return this._misses.get();
    }

    public int getHits() {
        return this._hits.get();
    }

    public double getHitRate() {
        int requests = this.getRequests();
        int hits = this.getHits();
        if (requests == 0) {
            return 0.0;
        }
        return (double)hits / (double)requests;
    }

    public synchronized Cache<K, V> logEveryNSeconds(int seconds, final ILogger logger) {
        if (this._loggingTask != null) {
            throw new IllegalStateException("Logging for " + this + " is already enabled");
        }
        ScheduledExecutorService service = Executors.newScheduledThreadPool(1);
        this._loggingTask = service.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                logger.info(Cache.this);
            }
        }, seconds, seconds, TimeUnit.SECONDS);
        return this;
    }

    public synchronized void stopLogging() {
        if (this._loggingTask != null) {
            this._loggingTask.cancel(false);
        }
    }

    public void clear() {
        this.clearCacheImpl();
        this._hits.set(0);
        this._misses.set(0);
        this._requests.set(0);
    }

    public String toString() {
        return "Cache \"" + this._name + "\"( Hits:" + this.getHits() + ", Misses:" + this.getMisses() + ", Requests:" + this.getRequests() + ", Hit rate:" + BigDecimal.valueOf(this.getHitRate() * 100.0).setScale(2, 1) + "% )";
    }

    public static <K, V> Cache<K, V> make(String name, int size, MissHandler<K, V> handler) {
        return new Cache<K, V>(name, size, handler);
    }

    public static interface MissHandler<L, W> {
        public W load(L var1);
    }
}

