/*
 * Decompiled with CFR 0.152.
 */
package manifold.rt.api.util;

public class ManEscapeUtil {
    public static String escapeForJava(String string) {
        StringBuffer resultBuffer = null;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char ch = string.charAt(i);
            String escape = ManEscapeUtil.escapeForJava(ch);
            if (escape != null) {
                if (resultBuffer == null) {
                    resultBuffer = new StringBuffer(string);
                    resultBuffer.setLength(i);
                }
                resultBuffer.append(escape);
                continue;
            }
            if (resultBuffer == null) continue;
            resultBuffer.append(ch);
        }
        String result = resultBuffer != null ? resultBuffer.toString() : string;
        return result;
    }

    public static String escapeForJava(char ch) {
        String escape = ManEscapeUtil.escapeForJavaStringLiteral(ch);
        if (escape == null && (ch <= '\u001f' || ch >= '\u007f')) {
            escape = ManEscapeUtil.getUnicodeEscape(ch);
        }
        return escape;
    }

    public static String escapeForJavaCharLiteral(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\"': {
                return "\"";
            }
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
        }
        if (c >= ' ' && c <= '~') {
            return String.valueOf(c);
        }
        return String.format("\\u%04x", c);
    }

    public static String escapeForJavaStringLiteral(String strText) {
        return ManEscapeUtil.escapeForJavaStringLiteral(strText, 0, strText.length());
    }

    public static String escapeForJavaStringLiteral(String strText, int iStart, int iEnd) {
        StringBuilder sb = new StringBuilder(strText.length());
        for (int i = iStart; i < iEnd; ++i) {
            sb.append(ManEscapeUtil.escapeForJavaStringLiteral(strText.charAt(i)));
        }
        return sb.toString();
    }

    public static String escapeForJavaStringLiteral(char ch) {
        switch (ch) {
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return ManEscapeUtil.isPrintableAscii(ch) ? String.valueOf(ch) : String.format("\\u%04x", ch);
    }

    private static boolean isPrintableAscii(char ch) {
        return ch >= ' ' && ch <= '~';
    }

    public static String getUnicodeEscape(char ch) {
        String strPrefix = "\\u";
        int iLen = strPrefix.length() + 4;
        String strHexValue = Integer.toHexString(ch);
        StringBuilder sb = new StringBuilder(iLen);
        sb.append(strPrefix);
        int n = iLen - (strPrefix.length() + strHexValue.length());
        for (int i = 0; i < n; ++i) {
            sb.append('0');
        }
        sb.append(strHexValue);
        return sb.toString();
    }

    public static String stripNewLinesAndExtraneousWhiteSpace(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean hitNewLine = false;
        boolean addedSpace = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                hitNewLine = true;
                continue;
            }
            if (c == ' ') {
                if (hitNewLine) {
                    if (addedSpace) continue;
                    result.append(c);
                    addedSpace = true;
                    continue;
                }
                result.append(c);
                continue;
            }
            hitNewLine = false;
            addedSpace = false;
            result.append(c);
        }
        return result.toString().trim();
    }

    public static String escapeForHTML(String string) {
        return ManEscapeUtil.escapeForHTML(string, true);
    }

    public static String escapeForHTML(String string, boolean escapeWhitespace) {
        if (string == null || string.length() == 0) {
            return string;
        }
        StringBuilder resultBuffer = null;
        int last = 0;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            String entity = null;
            char ch = string.charAt(i);
            switch (ch) {
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case ' ': {
                    if (last != 32 || !escapeWhitespace) break;
                    entity = "&nbsp;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '\'': {
                    entity = "&#39";
                    break;
                }
                case '\n': {
                    if (!escapeWhitespace) break;
                    entity = "<br>";
                    break;
                }
            }
            if (entity != null) {
                if (resultBuffer == null) {
                    resultBuffer = new StringBuilder(string);
                    resultBuffer.setLength(i);
                }
                resultBuffer.append(entity);
            } else if (resultBuffer != null) {
                resultBuffer.append(ch);
            }
            last = ch;
        }
        return resultBuffer != null ? resultBuffer.toString() : string;
    }
}

