/*
 * Decompiled with CFR 0.152.
 */
package manifold.rt.api.util;

public class Pair<F, S> {
    public static final And and = And.instance();
    final F _first;
    final S _second;

    public Pair(F first, S second) {
        this._first = first;
        this._second = second;
    }

    public F getFirst() {
        return this._first;
    }

    public S getSecond() {
        return this._second;
    }

    public static <T, V> Pair<T, V> make(T f, V s) {
        return new Pair<T, V>(f, s);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair pair = (Pair)o;
        if (this._first != null ? !this._first.equals(pair._first) : pair._first != null) {
            return false;
        }
        return this._second != null ? this._second.equals(pair._second) : pair._second == null;
    }

    public int hashCode() {
        int result = this._first != null ? this._first.hashCode() : 0;
        result = 31 * result + (this._second != null ? this._second.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "(" + this._first + ", " + this._second + ")";
    }

    public static class And {
        private static final And INSTANCE = new And();

        public static And instance() {
            return INSTANCE;
        }

        private And() {
        }

        public <F> First<F> postfixBind(F first) {
            return new First(first);
        }

        public static class First<F> {
            private F _first;

            private First(F left) {
                this._first = left;
            }

            public F getFirst() {
                return this._first;
            }

            public <S> Pair<F, S> prefixBind(S second) {
                return new Pair<F, S>(this._first, second);
            }
        }
    }
}

