/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext.props;

import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import manifold.ext.props.PropertyProcessor;
import manifold.ext.props.Util;
import manifold.ext.props.rt.api.propgen;
import manifold.internal.javac.IDynamicJdk;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

class ClassReaderCompleter
implements Symbol.Completer {
    private final PropertyProcessor _pp;
    private final Symbol.Completer _thisCompleter;
    private final BasicJavacTask _javacTask;

    static void replaceCompleter(PropertyProcessor propertyProcessor) {
        ReflectUtil.LiveFieldRef thisCompleterField;
        Context context = propertyProcessor.getContext();
        if (JreUtil.isJava8()) {
            ClassReader classReader = ClassReader.instance(context);
            thisCompleterField = ReflectUtil.field((Object)classReader, (String)"thisCompleter");
        } else {
            Object classFinder = ReflectUtil.method((String)"com.sun.tools.javac.code.ClassFinder", (String)"instance", (Class[])new Class[]{Context.class}).invokeStatic(new Object[]{context});
            thisCompleterField = ReflectUtil.field((Object)classFinder, (String)"thisCompleter");
        }
        Symbol.Completer thisCompleter = (Symbol.Completer)thisCompleterField.get();
        if (!(thisCompleter instanceof ClassReaderCompleter)) {
            ClassReaderCompleter myCompleter = new ClassReaderCompleter(propertyProcessor, thisCompleter, propertyProcessor.getJavacTask());
            thisCompleterField.set((Object)myCompleter);
            if (JreUtil.isJava9orLater()) {
                ReflectUtil.field((Object)Symtab.instance(context), (String)"initialCompleter").set((Object)myCompleter);
                ReflectUtil.field((Object)JavacProcessingEnvironment.instance(context), (String)"initialCompleter").set((Object)myCompleter);
            }
        }
    }

    private ClassReaderCompleter(PropertyProcessor propertyProcessor, Symbol.Completer thisCompleter, BasicJavacTask javacTask) {
        this._pp = propertyProcessor;
        this._thisCompleter = thisCompleter;
        this._javacTask = javacTask;
    }

    @Override
    public void complete(Symbol sym) throws Symbol.CompletionFailure {
        Context context = this._javacTask.getContext();
        this._thisCompleter.complete(sym);
        Names names = Names.instance(context);
        if (sym instanceof Symbol.ClassSymbol && sym.name != names.package_info) {
            Symbol.ClassSymbol classSym = this.completeAncestryFirst((Symbol.ClassSymbol)sym);
            Annotate annotate = Annotate.instance(context);
            if (this.restorePropFields(classSym, names)) {
                this._pp.inferPropertiesFromClassReader(classSym);
            } else {
                if (JreUtil.isJava8()) {
                    annotate.normal(() -> {
                        this.restorePropFields(classSym, names);
                        this._pp.inferPropertiesFromClassReader(classSym);
                    });
                } else {
                    ReflectUtil.method((Object)annotate, (String)"normal", (Class[])new Class[]{Runnable.class}).invoke(new Object[]{() -> {
                        this.restorePropFields(classSym, names);
                        this._pp.inferPropertiesFromClassReader(classSym);
                    }});
                }
                annotate.flush();
            }
        }
    }

    private Symbol.ClassSymbol completeAncestryFirst(Symbol.ClassSymbol sym) {
        Type superclass = sym.getSuperclass();
        if (superclass instanceof Type.ClassType) {
            try {
                Element enclClass = superclass.tsym.getEnclosingElement();
                if (enclClass instanceof Symbol.ClassSymbol) {
                    this.completeAncestryFirst((Symbol.ClassSymbol)enclClass);
                }
                superclass.tsym.complete();
            }
            catch (Symbol.CompletionFailure completionFailure) {
                // empty catch block
            }
        }
        sym.getInterfaces().forEach(iface -> {
            try {
                Element enclClass = iface.tsym.getEnclosingElement();
                if (enclClass instanceof Symbol.ClassSymbol) {
                    this.completeAncestryFirst((Symbol.ClassSymbol)enclClass);
                }
                iface.tsym.complete();
            }
            catch (Symbol.CompletionFailure completionFailure) {
                // empty catch block
            }
        });
        return sym;
    }

    private boolean restorePropFields(Symbol.ClassSymbol classSym, Names names) {
        boolean handled = false;
        for (Symbol sym : IDynamicJdk.instance().getMembers(classSym, false)) {
            Attribute.Compound propgen2;
            if (!(sym instanceof Symbol.VarSymbol) || (propgen2 = Util.getAnnotationMirror(sym, propgen.class)) == null) continue;
            sym.flags_field = sym.flags_field & 0xFFFFFFFFFFFFFFFDL | Util.getFlags(propgen2);
            handled = true;
        }
        block1: for (Symbol sym : IDynamicJdk.instance().getMembers(classSym, false)) {
            Attribute.Compound propgenAnno;
            if (!(sym instanceof Symbol.MethodSymbol) || (propgenAnno = Util.getAnnotationMirror(sym, propgen.class)) == null) continue;
            Name fieldName = names.fromString(this.getName(propgenAnno));
            for (Symbol existing : IDynamicJdk.instance().getMembersByName(classSym, fieldName, false)) {
                if (!(existing instanceof Symbol.VarSymbol)) continue;
                continue block1;
            }
            Symbol.MethodSymbol meth = (Symbol.MethodSymbol)sym;
            Type t = ((List)meth.getParameters()).isEmpty() ? meth.getReturnType() : ((Symbol.VarSymbol)((List)meth.getParameters()).get((int)0)).type;
            Symbol.VarSymbol propField = new Symbol.VarSymbol(Util.getFlags(propgenAnno), fieldName, t, classSym);
            propField.appendAttributes(List.from(propgenAnno.values.stream().filter(e -> e.snd instanceof Attribute.Array).map(e -> (Attribute.Compound)((Attribute.Array)e.snd).values[0]).collect(Collectors.toList())));
            ReflectUtil.method((Object)ReflectUtil.field((Object)classSym, (String)"members_field").get(), (String)"enter", (Class[])new Class[]{Symbol.class}).invoke(new Object[]{propField});
            handled = true;
        }
        return handled;
    }

    private String getName(Attribute.Compound anno) {
        for (Symbol.MethodSymbol methSym : anno.getElementValues().keySet()) {
            if (!((Name)methSym.getSimpleName()).toString().equals("name")) continue;
            return (String)anno.getElementValues().get(methSym).getValue();
        }
        throw new IllegalStateException();
    }
}

