/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext.props;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import manifold.ext.props.rt.api.Abstract;
import manifold.ext.props.rt.api.PropOption;
import manifold.ext.props.rt.api.get;
import manifold.ext.props.rt.api.set;
import manifold.ext.props.rt.api.val;
import manifold.ext.props.rt.api.var;

public class Util {
    static boolean sameAccess(Symbol sym1, Symbol sym2) {
        return Util.sameAccess((int)sym1.flags_field, (int)sym2.flags_field);
    }

    static boolean sameAccess(int flags1, int flags2) {
        return Util.getAccess(flags1) == Util.getAccess(flags2);
    }

    static int getAccess(Symbol classSym) {
        return Util.getAccess((int)classSym.flags_field);
    }

    static int getAccess(int flags) {
        return flags & 7;
    }

    static int getAccess(JCTree.JCClassDecl classDecl, int flags) {
        return Modifier.isPublic(flags) ? 1 : (Modifier.isProtected(flags) ? 4 : (Modifier.isPrivate(flags) ? 2 : (Util.isInterface(classDecl) ? 1 : 0)));
    }

    static boolean isInterface(JCTree.JCClassDecl classDecl) {
        return classDecl.getKind() == Tree.Kind.INTERFACE;
    }

    static int weakest(int acc1, int acc2) {
        return acc1 == 1 ? 1 : (acc2 == 1 ? 1 : (acc1 == 4 ? 4 : (acc2 == 4 ? 4 : (acc1 != 2 ? 0 : (acc2 != 2 ? 0 : 2)))));
    }

    static boolean isAbstract(JCTree.JCClassDecl classDecl, JCTree.JCVariableDecl propField) {
        if (Util.isInterface(classDecl) && !Util.isStatic(propField) && propField.init == null) {
            return true;
        }
        return Util.getAnnotation(propField, Abstract.class) != null;
    }

    static PropOption getAccess(JCTree.JCClassDecl classDecl, List<JCTree.JCExpression> args) {
        if (Util.isInterface(classDecl)) {
            return PropOption.Public;
        }
        return Util.hasOption(args, PropOption.Public) ? PropOption.Public : (Util.hasOption(args, PropOption.Protected) ? PropOption.Protected : (Util.hasOption(args, PropOption.Package) ? PropOption.Package : (Util.hasOption(args, PropOption.Private) ? PropOption.Private : null)));
    }

    static boolean hasOption(List<JCTree.JCExpression> args, PropOption option) {
        if (args == null) {
            return false;
        }
        return args.stream().anyMatch(e -> Util.isOption(option, e));
    }

    static boolean isOption(PropOption option, JCTree.JCExpression e) {
        if (e instanceof JCTree.JCLiteral) {
            return ((JCTree.JCLiteral)e).getValue() == option;
        }
        return e.toString().contains(option.name());
    }

    static JCTree.JCAnnotation getAnnotation(JCTree.JCVariableDecl field, Class<? extends Annotation> cls) {
        for (JCTree.JCAnnotation jcAnno : field.getModifiers().getAnnotations()) {
            if (cls.getSimpleName().equals(jcAnno.annotationType.toString())) {
                return jcAnno;
            }
            if (!cls.getTypeName().equals(jcAnno.annotationType.toString())) continue;
            return jcAnno;
        }
        return null;
    }

    static boolean isPropertyField(Symbol sym) {
        return sym != null && !sym.isLocal() && (Util.getAnnotationMirror(sym, var.class) != null || Util.getAnnotationMirror(sym, val.class) != null || Util.getAnnotationMirror(sym, get.class) != null || Util.getAnnotationMirror(sym, set.class) != null);
    }

    static boolean isReadableProperty(Symbol sym) {
        return sym != null && (Util.getAnnotationMirror(sym, var.class) != null || Util.getAnnotationMirror(sym, val.class) != null || Util.getAnnotationMirror(sym, get.class) != null);
    }

    static boolean isWritableProperty(Symbol sym) {
        return sym != null && (Util.getAnnotationMirror(sym, var.class) != null || Util.getAnnotationMirror(sym, set.class) != null);
    }

    static Attribute.Compound getAnnotationMirror(Symbol classSym, Class<? extends Annotation> annoClass) {
        for (Attribute.Compound anno : classSym.getAnnotationMirrors()) {
            if (!annoClass.getTypeName().equals(anno.type.tsym.getQualifiedName().toString())) continue;
            return anno;
        }
        return null;
    }

    static boolean isStatic(JCTree.JCVariableDecl propField) {
        long flags = propField.getModifiers().flags;
        return (flags & 8L) != 0L;
    }

    static long getFlags(Attribute.Compound anno) {
        for (Symbol.MethodSymbol methSym : anno.getElementValues().keySet()) {
            if (!((Name)methSym.getSimpleName()).toString().equals("flags")) continue;
            return ((Number)anno.getElementValues().get(methSym).getValue()).longValue();
        }
        throw new IllegalStateException();
    }

    static int getDeclaredAccess(Attribute.Compound anno) {
        for (Symbol.MethodSymbol methSym : anno.getElementValues().keySet()) {
            if (!((Name)methSym.getSimpleName()).toString().equals("declaredAccess")) continue;
            return ((Number)anno.getElementValues().get(methSym).getValue()).intValue();
        }
        return -1;
    }
}

