/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext.props;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import manifold.ext.props.Util;
import manifold.ext.props.rt.api.auto;
import manifold.ext.props.rt.api.propgen;
import manifold.ext.props.rt.api.set;
import manifold.ext.props.rt.api.val;
import manifold.ext.props.rt.api.var;
import manifold.internal.javac.IDynamicJdk;
import manifold.rt.api.util.ManStringUtil;
import manifold.rt.api.util.ReservedWordMapping;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

class PropertyInference {
    private final Consumer<Symbol.VarSymbol> _backingFieldConsumer;
    private final Supplier<Context> _contextSupplier;
    private final Supplier<CompilationUnitTree> _compilationUnitSupplier;

    PropertyInference(Consumer<Symbol.VarSymbol> backingFieldConsumer, Supplier<Context> contextSupplier, Supplier<CompilationUnitTree> compilationUnitSupplier) {
        this._backingFieldConsumer = backingFieldConsumer;
        this._contextSupplier = contextSupplier;
        this._compilationUnitSupplier = compilationUnitSupplier;
    }

    private Context context() {
        return this._contextSupplier.get();
    }

    void inferProperties(Symbol.ClassSymbol classSym) {
        HashMap<String, Set<PropAttrs>> fromGetter = new HashMap<String, Set<PropAttrs>>();
        HashMap<String, Set<PropAttrs>> fromSetter = new HashMap<String, Set<PropAttrs>>();
        for (Symbol sym : IDynamicJdk.instance().getMembers(classSym, false)) {
            if (!(sym instanceof Symbol.MethodSymbol)) continue;
            this.gatherCandidates((Symbol.MethodSymbol)sym, fromGetter, fromSetter);
        }
        this.handleVars(fromGetter, fromSetter);
        this.handleVals(fromGetter, fromSetter);
        this.handleWos(fromGetter, fromSetter);
    }

    private void gatherCandidates(Symbol.MethodSymbol m, Map<String, Set<PropAttrs>> fromGetter, Map<String, Set<PropAttrs>> fromSetter) {
        PropAttrs derivedFromSetter;
        Attribute.Compound propgenAnno = Util.getAnnotationMirror(m, propgen.class);
        if (propgenAnno != null) {
            return;
        }
        PropAttrs derivedFromGetter = this.derivePropertyNameFromGetter(m);
        if (derivedFromGetter != null) {
            fromGetter.computeIfAbsent(derivedFromGetter._name, key -> new HashSet()).add(derivedFromGetter);
        }
        if ((derivedFromSetter = this.derivePropertyNameFromSetter(m)) != null) {
            fromSetter.computeIfAbsent(derivedFromSetter._name, key -> new HashSet()).add(derivedFromSetter);
        }
    }

    private boolean isInherited(Symbol ancestorSym, Symbol.ClassSymbol origin) {
        Symbol.ClassSymbol ancestorClass = ancestorSym.enclClass();
        if (ancestorClass == origin) {
            return true;
        }
        if (ancestorSym.isStatic() && ancestorClass.isInterface()) {
            return false;
        }
        if (Modifier.isPublic((int)ancestorSym.flags_field) || Modifier.isProtected((int)ancestorSym.flags_field)) {
            return true;
        }
        if (Modifier.isPrivate((int)ancestorSym.flags_field)) {
            return ancestorClass.outermostClass() == origin.outermostClass();
        }
        return !Modifier.isPrivate((int)ancestorSym.flags_field) && ancestorClass.packge().equals(origin.packge());
    }

    private void handleVars(Map<String, Set<PropAttrs>> fromGetter, Map<String, Set<PropAttrs>> fromSetter) {
        block0: for (Map.Entry<String, Set<PropAttrs>> entry : fromGetter.entrySet()) {
            String name = entry.getKey();
            Set<PropAttrs> getters = entry.getValue();
            Set<PropAttrs> setters = fromSetter.get(name);
            if (getters == null || getters.isEmpty() || setters == null || setters.isEmpty()) continue;
            Types types = Types.instance(this.context());
            for (PropAttrs getAttr : getters) {
                Type getType = getAttr._type;
                for (PropAttrs setAttr : setters) {
                    Type setType = setAttr._type;
                    if (!types.isAssignable(getType, setType) || getAttr._m.isStatic() != setAttr._m.isStatic()) continue;
                    this.makeVar(getAttr, setAttr);
                    continue block0;
                }
            }
        }
    }

    private void handleVals(Map<String, Set<PropAttrs>> fromGetter, Map<String, Set<PropAttrs>> fromSetter) {
        for (Map.Entry<String, Set<PropAttrs>> entry : fromGetter.entrySet()) {
            Set<PropAttrs> setters;
            String name = entry.getKey();
            Set<PropAttrs> getters = entry.getValue();
            if (getters == null || getters.isEmpty() || (setters = fromSetter.get(name)) != null && !setters.isEmpty()) continue;
            this.makeVal(getters.iterator().next());
        }
    }

    private void handleWos(Map<String, Set<PropAttrs>> fromGetter, Map<String, Set<PropAttrs>> fromSetter) {
        for (Map.Entry<String, Set<PropAttrs>> entry : fromSetter.entrySet()) {
            Set<PropAttrs> getters;
            String name = entry.getKey();
            Set<PropAttrs> setters = entry.getValue();
            if (setters == null || setters.isEmpty() || (getters = fromGetter.get(name)) != null && !getters.isEmpty()) continue;
            this.makeWo(setters.iterator().next());
        }
    }

    private void makeVar(PropAttrs getAttr, PropAttrs setAttr) {
        Names names = Names.instance(this.context());
        Name fieldName = names.fromString(getAttr._name);
        Symbol.ClassSymbol classSym = getAttr._m.enclClass();
        Type t = this.getMoreSpecificType(getAttr._type, setAttr._type);
        int flags = Util.weakest(Util.getAccess(getAttr._m), Util.getAccess(setAttr._m));
        Pair<Integer, Symbol.VarSymbol> res = this.handleExistingField(fieldName, t, flags = (int)((long)flags | getAttr._m.flags_field & 8L), classSym, var.class);
        if (res == null) {
            return;
        }
        flags = (Integer)res.fst == Integer.MAX_VALUE ? flags : Util.weakest((Integer)res.fst, flags);
        Symbol.VarSymbol propField = new Symbol.VarSymbol(flags, fieldName, t, classSym);
        this.addField(propField, classSym, var.class);
    }

    private void makeVal(PropAttrs getAttr) {
        Symbol.ClassSymbol classSym;
        Names names = Names.instance(this.context());
        Name fieldName = names.fromString(getAttr._name);
        Pair<Integer, Symbol.VarSymbol> res = this.handleExistingField(fieldName, getAttr._type, (int)getAttr._m.flags_field, classSym = getAttr._m.enclClass(), val.class);
        if (res == null) {
            return;
        }
        int flags = (Integer)res.fst == Integer.MAX_VALUE ? Util.getAccess((int)getAttr._m.flags_field) : Util.weakest((Integer)res.fst, (int)getAttr._m.flags_field);
        flags = (int)((long)flags | getAttr._m.flags_field & 8L);
        Symbol.VarSymbol propField = new Symbol.VarSymbol(flags, fieldName, getAttr._type, classSym);
        Class varClass = Util.isWritableProperty((Symbol)res.snd) ? var.class : val.class;
        this.addField(propField, classSym, varClass);
    }

    private void makeWo(PropAttrs setAttr) {
        Symbol.ClassSymbol classSym;
        Names names = Names.instance(this.context());
        Name fieldName = names.fromString(setAttr._name);
        Pair<Integer, Symbol.VarSymbol> res = this.handleExistingField(fieldName, setAttr._type, (int)setAttr._m.flags_field, classSym = setAttr._m.enclClass(), set.class);
        if (res == null) {
            return;
        }
        int flags = (Integer)res.fst == Integer.MAX_VALUE ? Util.getAccess((int)setAttr._m.flags_field) : Util.weakest((Integer)res.fst, (int)setAttr._m.flags_field);
        Type t = setAttr._type;
        flags = (int)((long)flags | setAttr._m.flags_field & 8L);
        Symbol.VarSymbol propField = new Symbol.VarSymbol(flags, fieldName, t, classSym);
        Class varClass = Util.isReadableProperty((Symbol)res.snd) ? var.class : set.class;
        this.addField(propField, classSym, varClass);
    }

    private void addField(Symbol.VarSymbol propField, Symbol.ClassSymbol classSym, Class<? extends Annotation> varClass) {
        this.addField(propField, classSym, varClass, -1);
    }

    private void addField(Symbol.VarSymbol propField, Symbol.ClassSymbol classSym, Class<? extends Annotation> varClass, int existingDeclaredAccess) {
        Object ctx = this._compilationUnitSupplier.get();
        if (JreUtil.isJava9orLater()) {
            ctx = ReflectUtil.method((Object)JavacElements.instance(this.context()), (String)"getModuleElement", (Class[])new Class[]{CharSequence.class}).invoke(new Object[]{"manifold.props.rt"});
        }
        Symbol.ClassSymbol varSym = IDynamicJdk.instance().getTypeElement(this.context(), ctx, varClass.getTypeName());
        Symbol.ClassSymbol autoSym = IDynamicJdk.instance().getTypeElement(this.context(), ctx, auto.class.getTypeName());
        if (varSym != null) {
            Attribute.Compound autoAnno;
            Attribute.Compound varAnno = new Attribute.Compound(varSym.type, List.nil());
            if (existingDeclaredAccess == -1) {
                autoAnno = new Attribute.Compound(autoSym.type, List.nil());
            } else {
                Names names = Names.instance(this.context());
                Symtab symtab = Symtab.instance(this.context());
                Symbol.MethodSymbol declaredAccessMeth = (Symbol.MethodSymbol)IDynamicJdk.instance().getMembersByName(autoSym, names.fromString("declaredAccess")).iterator().next();
                autoAnno = new Attribute.Compound(autoSym.type, List.of(new Pair<Symbol.MethodSymbol, Attribute.Constant>(declaredAccessMeth, new Attribute.Constant(symtab.intType, existingDeclaredAccess))));
                this._backingFieldConsumer.accept(propField);
            }
            propField.appendAttributes(List.of(varAnno, autoAnno));
            if (classSym != null) {
                ReflectUtil.method((Object)ReflectUtil.field((Object)classSym, (String)"members_field").get(), (String)"enter", (Class[])new Class[]{Symbol.class}).invoke(new Object[]{propField});
            }
        }
    }

    private Type getMoreSpecificType(Type t1, Type t2) {
        Types types = Types.instance(this.context());
        if (types.isSameType(t1, t2)) {
            return t1;
        }
        return types.isAssignable(t1, t2) ? t1 : t2;
    }

    private Pair<Integer, Symbol.VarSymbol> handleExistingField(Name fieldName, Type t, int flags, Symbol.ClassSymbol classSym, Class<? extends Annotation> varClass) {
        Symbol[] existing = this.findExistingFieldInAncestry(fieldName, classSym, classSym);
        if (existing != null && existing.length > 0) {
            Symbol.VarSymbol exField = (Symbol.VarSymbol)existing[0];
            Types types = Types.instance(this.context());
            if (types.isAssignable(exField.type, t) && Modifier.isStatic((int)exField.flags_field) == Modifier.isStatic(flags) && !exField.owner.isInterface() && (!Modifier.isPublic((int)exField.flags_field) || Util.isPropertyField(exField))) {
                int weakest = Util.weakest(Util.getAccess((int)exField.flags_field), Util.getAccess(flags));
                if (exField.enclClass() == classSym) {
                    int declaredAccess = (int)exField.flags_field & 7;
                    exField.flags_field = exField.flags_field & 0xFFFFFFFFFFFFFFF8L | (long)weakest;
                    this.addField(exField, null, varClass, declaredAccess);
                    return null;
                }
                if (Util.isPropertyField(exField)) {
                    return new Pair<Integer, Symbol.VarSymbol>(weakest, exField);
                }
            }
            return null;
        }
        return new Pair<Integer, Object>(Integer.MAX_VALUE, null);
    }

    private Symbol[] findExistingFieldInAncestry(Name name, Symbol.TypeSymbol c, Symbol.ClassSymbol origin) {
        Symbol[] sym2;
        if (!(c instanceof Symbol.ClassSymbol)) {
            return null;
        }
        Types types = Types.instance(this.context());
        for (Symbol[] sym2 : IDynamicJdk.instance().getMembersByName((Symbol.ClassSymbol)c, name)) {
            Symbol[] symbolArray;
            if (!(sym2 instanceof Symbol.VarSymbol)) continue;
            if (this.isInherited((Symbol)sym2, origin)) {
                Symbol[] symbolArray2 = new Symbol[1];
                symbolArray = symbolArray2;
                symbolArray2[0] = sym2;
            } else {
                symbolArray = new Symbol[]{};
            }
            return symbolArray;
        }
        Type st = types.supertype(c.type);
        if (st != null && st.hasTag(TypeTag.CLASS) && (sym2 = this.findExistingFieldInAncestry(name, st.tsym, origin)) != null) {
            return sym2;
        }
        List<Type> l = types.interfaces(c.type);
        while (l.nonEmpty()) {
            Symbol[] sym3 = this.findExistingFieldInAncestry(name, ((Type)l.head).tsym, origin);
            if (sym3 != null && sym3.length > 0 && !Modifier.isStatic((int)sym3[0].flags_field)) {
                return sym3;
            }
            l = l.tail;
        }
        return null;
    }

    private PropAttrs derivePropertyNameFromGetter(Symbol.MethodSymbol m) {
        Symtab symtab = Symtab.instance(this.context());
        if (m.getReturnType() == symtab.voidType || !((List)m.getParameters()).isEmpty()) {
            return null;
        }
        PropAttrs derived = this.deriveName(m, "get", m.getReturnType());
        return derived == null ? this.deriveName(m, "is", m.getReturnType()) : derived;
    }

    private PropAttrs derivePropertyNameFromSetter(Symbol.MethodSymbol m) {
        return ((List)m.getParameters()).length() != 1 ? null : this.deriveName(m, "set", ((Symbol.VarSymbol)((List)m.getParameters()).get((int)0)).type);
    }

    private PropAttrs deriveName(Symbol.MethodSymbol m, String prefix, Type type) {
        String derived;
        String name = ((Name)m.getSimpleName()).toString();
        if (name.startsWith(prefix) && !(derived = name.substring(prefix.length())).isEmpty()) {
            char first = derived.charAt(0);
            if (Character.isUpperCase(first) || first == '$') {
                String propName;
                if ("is".equals(prefix) && first != '$') {
                    derived = prefix + derived;
                }
                if ((propName = ManStringUtil.uncapitalize((String)derived)).equals(ReservedWordMapping.getIdentifierForName((String)propName))) {
                    return new PropAttrs(prefix, propName, type, m);
                }
            } else if (first == '_') {
                StringBuilder sb = new StringBuilder(derived);
                while (sb.length() > 0 && sb.charAt(0) == '_') {
                    sb.deleteCharAt(0);
                }
                if (sb.length() > 0) {
                    String propName;
                    if ("is".equals(prefix)) {
                        sb = new StringBuilder(prefix + ManStringUtil.capitalize((String)sb.toString()));
                    }
                    if ((propName = sb.toString()).equals(ReservedWordMapping.getIdentifierForName((String)propName))) {
                        return new PropAttrs(prefix, propName, type, m);
                    }
                }
            }
        }
        return null;
    }

    private static class PropAttrs {
        String _prefix;
        String _name;
        Type _type;
        Symbol.MethodSymbol _m;

        PropAttrs(String prefix, String name, Type type, Symbol.MethodSymbol m) {
            this._prefix = prefix;
            this._name = name;
            this._type = type;
            this._m = m;
        }
    }
}

