/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext.props.rt.api;

import java.util.Arrays;

public enum PropOption {
    Abstract(1024),
    Final(16),
    Private(2),
    Package(0),
    Protected(4),
    Public(1);

    private final int _modifier;

    private PropOption(int modifier) {
        this._modifier = modifier;
    }

    public int getModifier() {
        return this._modifier;
    }

    public int or(PropOption option) {
        return this.or(option.getModifier());
    }

    public int or(int modifier) {
        return this.getModifier() | modifier;
    }

    public static PropOption fromModifier(int modifier) {
        return Arrays.stream(PropOption.values()).filter(e -> e.getModifier() == modifier).findFirst().orElseThrow(() -> new IllegalArgumentException("Bad modifier: " + modifier));
    }
}

