/*
 * Decompiled with CFR 0.152.
 */
package manifold.preprocessor.definitions;

import java.util.HashSet;
import java.util.Set;
import manifold.preprocessor.api.SymbolProvider;
import manifold.preprocessor.definitions.Definitions;
import manifold.rt.api.util.ServiceUtil;
import manifold.util.concurrent.LocklessLazyVar;

public class ServiceDefinitions
extends Definitions {
    public static final LocklessLazyVar<Set<SymbolProvider>> REGISTERED_SYMBOL_PROVIDERS = LocklessLazyVar.make(() -> {
        HashSet registered = new HashSet();
        ServiceUtil.loadRegisteredServices(registered, SymbolProvider.class, (ClassLoader)ServiceDefinitions.class.getClassLoader());
        return registered;
    });
    private final Definitions _rootDefinitions;

    public ServiceDefinitions(Definitions rootDefinitions) {
        super(rootDefinitions.getSourceFile());
        this._rootDefinitions = rootDefinitions;
    }

    public Definitions getRootDefinitions() {
        return this._rootDefinitions;
    }

    @Override
    protected Definitions loadParentDefinitions() {
        return null;
    }

    @Override
    public boolean isDefined(String def) {
        Set providers = (Set)REGISTERED_SYMBOL_PROVIDERS.get();
        return providers.stream().anyMatch(p -> p.isDefined(this.getRootDefinitions(), this.getSourceFile(), def));
    }

    @Override
    public String getValue(String def) {
        Set providers = (Set)REGISTERED_SYMBOL_PROVIDERS.get();
        return providers.stream().filter(p -> p.isDefined(this.getRootDefinitions(), this.getSourceFile(), def)).map(p -> p.getValue(this.getRootDefinitions(), this.getSourceFile(), def)).map(v -> v == null ? "" : v).findFirst().orElse(null);
    }
}

