/*
 * Decompiled with CFR 0.152.
 */
package manifold.preprocessor.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import manifold.preprocessor.definitions.Definitions;
import manifold.preprocessor.expression.ParseError;

public abstract class Expression {
    private final List<ParseError> _errors = new ArrayList<ParseError>();
    private final int _startOffset;
    private final int _endOffset;

    public Expression(int startOffset, int endOffset) {
        this._startOffset = startOffset;
        this._endOffset = endOffset;
    }

    public abstract List<Expression> getChildren();

    public abstract boolean evaluate(Definitions var1);

    public String getValue(Definitions definitions) {
        return String.valueOf(this.evaluate(definitions));
    }

    public int getStartOffset() {
        return this._startOffset;
    }

    public int getEndOffset() {
        return this._endOffset;
    }

    void error(String message, int tokenStart) {
        this._errors.add(new ParseError(message, tokenStart));
    }

    public boolean visitErrors(Predicate<ParseError> visitor) {
        for (ParseError e : this._errors) {
            if (visitor.test(e)) continue;
            return false;
        }
        for (Expression child : this.getChildren()) {
            if (child.visitErrors(visitor)) continue;
            return false;
        }
        return true;
    }

    public boolean hasErrors() {
        return !this.visitErrors(e -> false);
    }
}

