/*
 * Decompiled with CFR 0.152.
 */
package manifold.preprocessor.expression;

import manifold.preprocessor.definitions.Definitions;
import manifold.preprocessor.expression.TerminalExpression;

public class StringLiteral
extends TerminalExpression {
    private final String _rawString;

    StringLiteral(String rawString, int start, int end) {
        super(start, end);
        if (rawString == null) {
            throw new IllegalArgumentException("Null string not allowed");
        }
        this._rawString = rawString;
    }

    @Override
    public boolean evaluate(Definitions definitions) {
        return true;
    }

    @Override
    public String getValue(Definitions definitions) {
        String unquoted = this._rawString.substring(1, this._rawString.length() > 1 && this._rawString.endsWith("\"") ? this._rawString.length() - 1 : this._rawString.length());
        return this.unescape(unquoted);
    }

    public String toString() {
        return this._rawString;
    }

    private String unescape(String rawString) {
        StringBuilder result = new StringBuilder();
        int length = rawString.length();
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = rawString.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                result.append(ch);
                continue;
            }
            int octalEscapeMaxLength = 2;
            switch (ch) {
                case 'n': {
                    result.append('\n');
                    break;
                }
                case 'r': {
                    result.append('\r');
                    break;
                }
                case 'b': {
                    result.append('\b');
                    break;
                }
                case 't': {
                    result.append('\t');
                    break;
                }
                case 'f': {
                    result.append('\f');
                    break;
                }
                case '\'': {
                    result.append('\'');
                    break;
                }
                case '\"': {
                    result.append('\"');
                    break;
                }
                case '\\': {
                    result.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.parseInt(rawString.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            result.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            result.append("\\u");
                        }
                        break;
                    }
                    result.append("\\u");
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    octalEscapeMaxLength = 3;
                }
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int escapeEnd;
                    for (escapeEnd = idx + 1; escapeEnd < length && escapeEnd < idx + octalEscapeMaxLength && this.isOctalDigit(rawString.charAt(escapeEnd)); ++escapeEnd) {
                    }
                    try {
                        result.append((char)Integer.parseInt(rawString.substring(idx, escapeEnd), 8));
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Couldn't parse " + rawString.substring(idx, escapeEnd), e);
                    }
                    idx = escapeEnd - 1;
                    break;
                }
                default: {
                    result.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            result.append('\\');
        }
        return result.toString();
    }

    private boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }
}

