/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.util.List;
import manifold.api.fs.IFile;
import manifold.api.host.IManifoldHost;
import manifold.api.json.AbstractJsonTypeManifold;
import manifold.api.json.codegen.DynamicType;
import manifold.api.json.codegen.IJsonParentType;
import manifold.api.json.codegen.IJsonType;
import manifold.api.json.codegen.JsonBasicType;
import manifold.api.json.codegen.JsonListType;
import manifold.api.json.codegen.JsonStructureType;
import manifold.api.json.codegen.schema.JsonSchemaTransformer;
import manifold.api.json.codegen.schema.JsonSchemaTransformerSession;
import manifold.api.json.codegen.schema.JsonSchemaType;
import manifold.api.json.codegen.schema.JsonUnionType;
import manifold.api.json.codegen.schema.TypeAttributes;
import manifold.json.rt.parser.Token;
import manifold.rt.api.Bindings;
import manifold.rt.api.util.Pair;

public class JsonTransformer {
    public static String makeStructureTypes(IManifoldHost host, String nameForStructure, Bindings bindings, AbstractJsonTypeManifold tm, boolean mutable) {
        JsonStructureType type = (JsonStructureType)JsonTransformer.transformJsonObject(host, nameForStructure, null, bindings);
        StringBuilder sb = new StringBuilder();
        type.render(tm, sb, 0, mutable);
        return sb.toString();
    }

    public static IJsonType transformJsonObject(IManifoldHost host, String name, JsonSchemaType parent, Object jsonObj) {
        return JsonTransformer.transformJsonObject(host, name, null, parent, jsonObj);
    }

    public static IJsonType transformJsonObject(IManifoldHost host, String name, IFile source, JsonSchemaType parent, Object jsonObj) {
        if (source == null && parent == null) {
            throw new RuntimeException("Invalid state, both source and parent are null.");
        }
        IJsonType type = null;
        if (parent != null) {
            type = parent.findChild(name);
        }
        if (jsonObj instanceof Pair) {
            jsonObj = ((Pair)jsonObj).getSecond();
        }
        if (jsonObj == null) {
            return DynamicType.instance();
        }
        if (jsonObj instanceof Bindings) {
            if (JsonSchemaTransformer.isSchema((Bindings)jsonObj)) {
                type = JsonSchemaTransformer.transform(host, name, source, jsonObj);
            } else {
                if (!(type instanceof JsonStructureType)) {
                    type = new JsonStructureType(parent, source, name, new TypeAttributes());
                }
                for (Object k : ((Bindings)jsonObj).keySet()) {
                    IJsonType memberType;
                    String key = (String)k;
                    Object value = ((Bindings)jsonObj).get((Object)key);
                    Token token = null;
                    if (value instanceof Pair) {
                        token = ((Token[])((Pair)value).getFirst())[0];
                    }
                    if ((memberType = JsonTransformer.transformJsonObject(host, key, (JsonSchemaType)type, value)) == null) continue;
                    ((JsonStructureType)type).addMember(key, memberType, token);
                }
                if (parent != null) {
                    parent.addChild(name, (IJsonParentType)type);
                }
            }
        } else if (jsonObj instanceof List) {
            if (!(type instanceof JsonListType)) {
                type = new JsonListType(name, source, parent, new TypeAttributes());
            }
            IJsonType compType = ((JsonListType)type).getComponentType();
            if (!((List)jsonObj).isEmpty()) {
                String nameItem = name + "Item";
                int i = 0;
                boolean isDissimilar = JsonTransformer.isDissimilar((List)jsonObj);
                for (Object elem : (List)jsonObj) {
                    IJsonType csr = JsonTransformer.transformJsonObject(host, nameItem + (isDissimilar ? Integer.valueOf(i++) : ""), (JsonSchemaType)type, elem);
                    if (compType != null && csr != compType && compType != DynamicType.instance()) {
                        csr = JsonTransformer.mergeTypes(compType, csr);
                    }
                    compType = csr;
                }
            } else if (compType == null) {
                compType = DynamicType.instance();
            }
            ((JsonListType)type).setComponentType(compType);
            if (parent != null) {
                parent.addChild(name, (IJsonParentType)type);
            }
        } else {
            type = JsonBasicType.get(jsonObj);
        }
        if (parent == null && type instanceof JsonSchemaType) {
            ((JsonSchemaType)type).resolveRefs();
            JsonSchemaTransformerSession.instance().maybeClear();
        }
        return type;
    }

    private static boolean isDissimilar(List jsonObj) {
        Class<?> type = null;
        for (Object o : jsonObj) {
            Class<?> csr;
            if (type == null) {
                type = o == null ? null : o.getClass();
                continue;
            }
            Class<?> clazz = csr = o == null ? null : o.getClass();
            if (csr != null && csr != type) {
                return true;
            }
            type = csr;
        }
        return false;
    }

    public static IJsonType mergeTypes(IJsonType type1, IJsonType type2) {
        IJsonType mergedType = JsonTransformer.mergeTypesNoUnion(type1, type2);
        if (mergedType == null && type1.getParent() instanceof JsonListType) {
            JsonListType listType = (JsonListType)type1.getParent();
            JsonUnionType unionType = new JsonUnionType(listType, listType.getFile(), "UnionType", new TypeAttributes());
            unionType.merge(type1);
            unionType.merge(type2);
            mergedType = unionType;
        }
        if (mergedType != null) {
            return mergedType;
        }
        throw new RuntimeException("Incompatible types: " + type1.getIdentifier() + " vs: " + (type2 instanceof JsonListType ? "Array: " : "") + type2.getIdentifier());
    }

    public static IJsonType mergeTypesNoUnion(IJsonType type1, IJsonType type2) {
        if (type1 == null) {
            return type2;
        }
        if (type2 == null) {
            return type1;
        }
        if (type1.equalsStructurally(type2)) {
            return type1;
        }
        if (type1 == DynamicType.instance()) {
            return type2;
        }
        if (type2 == DynamicType.instance()) {
            return type1;
        }
        IJsonType mergedType = type1.merge(type2);
        if (mergedType == null) {
            mergedType = type2.merge(type1);
        }
        return mergedType;
    }
}

