/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.codegen.schema;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import manifold.json.rt.api.DataBindings;
import manifold.rt.api.Bindings;
import manifold.rt.api.util.Pair;

public final class TypeAttributes {
    private Map<String, Object> _attributes;

    public TypeAttributes() {
        this(null, (Bindings)new DataBindings());
    }

    public TypeAttributes(Boolean nullable) {
        this(nullable, (Bindings)new DataBindings());
    }

    public TypeAttributes(Bindings bindings) {
        this(null, (Bindings)new DataBindings());
        this.assignAttribute(bindings, "nullable");
    }

    public TypeAttributes(Boolean nullable, Bindings jsonObj) {
        this._attributes = new HashMap<String, Object>();
        this._attributes.put("nullable", nullable);
        this.assignAttributes(jsonObj);
    }

    private TypeAttributes(Map<String, Object> attributes) {
        this._attributes = attributes;
    }

    private void assignAttributes(Bindings jsonObj) {
        for (String attr : AttributeTypes.INSTANCE.getNames()) {
            if (attr.equals("nullable")) continue;
            this.assignAttribute(jsonObj, attr);
        }
    }

    private void assignAttribute(Bindings jsonObj, String attr) {
        boolean hasAttr = jsonObj.containsKey((Object)attr);
        if (hasAttr) {
            Object attrValue = jsonObj.get((Object)attr);
            if (attrValue instanceof Pair) {
                attrValue = ((Pair)attrValue).getSecond();
            }
            this._attributes.put(attr, attrValue);
        }
    }

    public TypeAttributes overrideWith(TypeAttributes other) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(this._attributes);
        for (Map.Entry<String, Object> otherAttr : other._attributes.entrySet()) {
            Object existingValue = this._attributes.get(otherAttr.getKey());
            Object otherValue = otherAttr.getValue();
            attributes.put(otherAttr.getKey(), AttributeTypes.OVERRIDE.apply(existingValue, otherValue));
        }
        return new TypeAttributes(attributes);
    }

    public TypeAttributes blendWith(TypeAttributes other) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (Map.Entry<String, Object> myAttr : this._attributes.entrySet()) {
            Object myValue = myAttr.getValue();
            String name = myAttr.getKey();
            Object otherValue = other._attributes.get(name);
            attributes.put(name, AttributeTypes.INSTANCE.getMerger(name).apply(myValue, otherValue));
        }
        return new TypeAttributes(attributes);
    }

    public TypeAttributes copy() {
        HashMap<String, Object> copy = new HashMap<String, Object>(this._attributes);
        return new TypeAttributes(copy);
    }

    public Boolean getNullable() {
        return (Boolean)this._attributes.get("nullable");
    }

    void setNullable(Boolean nullable) {
        this._attributes.put("nullable", nullable);
    }

    public Object getDefaultValue() {
        return this._attributes.get("default");
    }

    public void setDefaultValue(Object value) {
        this._attributes.put("default", value);
    }

    public Boolean getReadOnly() {
        return (Boolean)this._attributes.get("readOnly");
    }

    public Boolean getWriteOnly() {
        return (Boolean)this._attributes.get("writeOnly");
    }

    public Object getAdditionalProperties() {
        return this._attributes.get("additionalProperties");
    }

    public Bindings getPatternProperties() {
        return (Bindings)this._attributes.get("patternProperties");
    }

    public static Boolean or(Boolean b1, Boolean b2) {
        Boolean nullableValue = b1;
        if (nullableValue == null) {
            nullableValue = b2;
        } else if (b2 != null) {
            nullableValue = nullableValue | b2;
        }
        return nullableValue;
    }

    public static Boolean and(Boolean b1, Boolean b2) {
        Boolean nullableValue = b1;
        if (nullableValue == null) {
            nullableValue = b2;
        } else if (b2 != null) {
            nullableValue = nullableValue & b2;
        }
        return nullableValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeAttributes that = (TypeAttributes)o;
        return Objects.equals(this._attributes, that._attributes);
    }

    public int hashCode() {
        return Objects.hash(this._attributes);
    }

    static class AttributeTypes {
        private static final BiFunction<Boolean, Boolean, Boolean> TRUE_IF_BOTH_TRUE = AttributeTypes::trueIfBothTrue;
        private static final BiFunction<Boolean, Boolean, Boolean> TRUE_IF_ONE_TRUE = AttributeTypes::trueIfOneTrue;
        static final BiFunction<Object, Object, Object> OVERRIDE = (o1, o2) -> o2 != null ? o2 : o1;
        static final BiFunction<Bindings, Bindings, Bindings> MERGE = (o1, o2) -> {
            DataBindings o3 = new DataBindings();
            if (o1 != null) {
                o3.putAll((Map)o1);
            }
            if (o2 != null) {
                o3.putAll((Map)o2);
            }
            return o3;
        };
        private static final AttributeTypes INSTANCE = new AttributeTypes();
        private final Map<String, BiFunction> _types = new HashMap<String, BiFunction>();

        private AttributeTypes() {
            this._types.put("nullable", TRUE_IF_BOTH_TRUE);
            this._types.put("readOnly", TRUE_IF_BOTH_TRUE);
            this._types.put("writeOnly", TRUE_IF_BOTH_TRUE);
            this._types.put("default", OVERRIDE);
            this._types.put("additionalProperties", OVERRIDE);
            this._types.put("patternProperties", MERGE);
        }

        private static Boolean trueIfOneTrue(Boolean o1, Boolean o2) {
            if (o1 != null && o2 != null) {
                return o1 != false || o2 != false;
            }
            if (o1 != null) {
                return o1;
            }
            return o2;
        }

        private static Boolean trueIfBothTrue(Boolean o1, Boolean o2) {
            if (o1 != null && o2 != null) {
                return o1 != false && o2 != false;
            }
            if (o1 != null) {
                return o1;
            }
            return o2;
        }

        Set<String> getNames() {
            return this._types.keySet();
        }

        BiFunction getMerger(String name) {
            return this._types.get(name);
        }
    }
}

