/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.xml.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import manifold.api.xml.parser.XmlAttribute;
import manifold.api.xml.parser.XmlNamedPart;
import manifold.api.xml.parser.XmlTerminal;
import manifold.api.xml.parser.antlr.XMLParser;

public class XmlElement
extends XmlNamedPart {
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private List<XmlElement> _children;
    private Map<String, XmlAttribute> _attributes;
    private XmlTerminal _content;

    XmlElement(XMLParser.ElementContext ctx, XmlElement parent) {
        super(parent, ctx.start.getStartIndex(), ctx.stop.getStopIndex() - ctx.start.getStartIndex() + 1, ctx.start.getLine());
        this.setName(new XmlTerminal(ctx.Name(0).getSymbol(), this));
        this._children = Collections.emptyList();
        this._attributes = Collections.emptyMap();
    }

    XmlElement(XMLParser.PrologContext ctx, XmlElement parent) {
        super(parent, ctx.start.getStartIndex(), ctx.stop.getStopIndex() - ctx.start.getStartIndex() + 1, ctx.start.getLine());
        this.setName(new XmlTerminal(ctx.getStart(), this));
        this._children = Collections.emptyList();
        this._attributes = Collections.emptyMap();
    }

    public List<XmlElement> getChildren() {
        return this._children;
    }

    void addChild(XmlElement child) {
        if (this._children.isEmpty()) {
            this._children = new ArrayList<XmlElement>();
        }
        this._children.add(child);
    }

    public Map<String, XmlAttribute> getAttributes() {
        return this._attributes;
    }

    void addAttribute(XmlAttribute attr) {
        if (this._attributes.isEmpty()) {
            this._attributes = new LinkedHashMap<String, XmlAttribute>();
        }
        this._attributes.put(attr.getName().getRawText(), attr);
    }

    public String getContent() {
        return this._content == null ? null : this.getActualValue(this._content.getRawText());
    }

    private String getActualValue(String rawText) {
        if (rawText == null) {
            return null;
        }
        rawText = rawText.trim();
        rawText = this.removeCDATA(rawText);
        rawText = rawText.trim();
        return rawText;
    }

    private String removeCDATA(String rawText) {
        if (rawText.startsWith(CDATA_START) && (rawText = rawText.substring(CDATA_START.length())).endsWith(CDATA_END)) {
            rawText = rawText.substring(0, rawText.length() - CDATA_END.length());
        }
        return rawText;
    }

    public XmlTerminal getRawContent() {
        return this._content;
    }

    void setRawContent(XmlTerminal content) {
        this._content = content;
        if (content.getParent() != this) {
            throw new IllegalStateException("Parent mismatch");
        }
    }
}

