/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.io.IOException;
import javax.script.Bindings;
import manifold.api.csv.Csv;
import manifold.api.json.Json;
import manifold.api.xml.Xml;
import manifold.api.yaml.Yaml;

public class Writer {
    private final Object _value;

    public Writer(Bindings jsonBindings) {
        this._value = jsonBindings;
    }

    public Writer(Iterable<?> jsonList) {
        this._value = jsonList;
    }

    public Writer(Object jsonValue) {
        this._value = jsonValue;
    }

    public String toJson() {
        return Json.toJson(this._value);
    }

    public void toJson(Appendable target) {
        try {
            target.append(Json.toJson(this._value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toYaml() {
        StringBuilder sb = new StringBuilder();
        Yaml.toYaml(this._value, sb);
        return sb.toString();
    }

    public void toYaml(Appendable target) {
        try {
            target.append(this.toYaml());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toXml() {
        return Xml.toXml(this._value);
    }

    public void toXml(Appendable target) {
        try {
            target.append(Xml.toXml(this._value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toXml(String name) {
        StringBuilder sb = new StringBuilder();
        Xml.toXml(this._value, name, sb, 0);
        return sb.toString();
    }

    public String toCsv() {
        return Csv.toCsv(this._value);
    }

    public void toCsv(Appendable target) {
        try {
            target.append(Csv.toCsv(this._value));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toCsv(String name) {
        StringBuilder sb = new StringBuilder();
        Csv.toCsv(this._value, name, sb, 0);
        return sb.toString();
    }
}

