/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.Bindings;
import manifold.api.json.Token;
import manifold.api.json.TokenType;
import manifold.api.util.Pair;
import manifold.api.util.xml.XmlAttribute;
import manifold.api.util.xml.XmlElement;
import manifold.api.util.xml.XmlParser;
import manifold.api.util.xml.XmlTerminal;
import manifold.ext.DataBindings;

public class Xml {
    private static final String XML_ELEM_CONTENT = "textContent";

    public static Bindings fromXml(String xml) {
        return Xml.fromXml(xml, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bindings fromXml(String xml, boolean withTokens) {
        try (BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(xml.getBytes()));){
            XmlElement elem = XmlParser.parse((InputStream)inputStream);
            DataBindings dataBindings = Xml.transform(new DataBindings(), elem, withTokens);
            return dataBindings;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static DataBindings transform(DataBindings parent, XmlElement elem, boolean withTokens) {
        DataBindings children = new DataBindings();
        parent.put(elem.getName().getRawText(), withTokens ? Xml.makeTokensValue(elem, (Bindings)children) : children);
        if (elem.getRawContent() != null) {
            children.put(XML_ELEM_CONTENT, (Object)elem.getRawContent().getRawText().trim());
        }
        LinkedHashMap<String, List> map = new LinkedHashMap<String, List>();
        for (XmlElement xmlElement : elem.getChildren()) {
            map.computeIfAbsent(xmlElement.getName().getRawText(), k -> new ArrayList()).add(Xml.transform(new DataBindings(), xmlElement, withTokens));
        }
        for (Map.Entry entry : map.entrySet()) {
            List list = (List)entry.getValue();
            if (list.size() == 1) {
                children.putAll((Map)list.get(0));
                continue;
            }
            List<Object> listValues = list.stream().map(e -> e.get(entry.getKey())).collect(Collectors.toList());
            children.put((String)entry.getKey(), withTokens ? Xml.makeTokensValue(listValues) : listValues);
        }
        for (Map.Entry entry : elem.getAttributes().entrySet()) {
            children.put((String)entry.getKey(), withTokens ? Xml.makeTokensValue((XmlAttribute)entry.getValue()) : ((XmlAttribute)entry.getValue()).getValue());
        }
        return parent;
    }

    private static Object makeTokensValue(XmlElement elem, Bindings value) {
        Token keyToken = Xml.makeToken(elem.getName());
        return new Pair((Object)new Token[]{keyToken, null}, (Object)value);
    }

    private static Object makeTokensValue(List<Object> value) {
        Object item = value.get(0);
        if (item instanceof Pair) {
            return new Pair(((Pair)item).getFirst(), value);
        }
        return value;
    }

    private static Object makeTokensValue(XmlAttribute attr) {
        Token keyToken = Xml.makeToken(attr.getName());
        XmlTerminal rawValue = attr.getRawValue();
        Token valueToken = rawValue == null ? null : Xml.makeToken(rawValue);
        return new Pair((Object)new Token[]{keyToken, valueToken}, (Object)attr.getValue());
    }

    private static Token makeToken(XmlTerminal value) {
        return new Token(TokenType.STRING, value.getRawText(), value.getOffset(), value.getLine(), -1);
    }
}

