/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.util.Set;
import javax.script.ScriptException;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.host.IManifoldHost;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonIssueContainer;
import manifold.api.json.JsonListType;
import manifold.api.json.JsonStructureType;
import manifold.api.type.AbstractSingleFileModel;
import manifold.api.type.ResourceFileTypeManifold;
import manifold.api.util.JavacDiagnostic;
import manifold.ext.DataBindings;
import manifold.internal.javac.IIssue;
import manifold.internal.javac.SourceJavaFileObject;

class Model
extends AbstractSingleFileModel {
    private JsonStructureType _type;
    private JsonIssueContainer _issues;

    Model(IManifoldHost host, String fqn, Set<IFile> files) {
        super(host, fqn, files);
        this.init();
    }

    private void init() {
        Object jsonValue;
        try {
            jsonValue = Json.fromJson(ResourceFileTypeManifold.getContent((IFile)this.getFile()));
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof ScriptException) {
                this._issues = new JsonIssueContainer((ScriptException)cause, this.getFile());
            }
            jsonValue = new DataBindings();
        }
        IJsonType type = Json.transformJsonObject(this.getHost(), this.getFile().getBaseName(), null, jsonValue);
        this._type = this.getStructureType(type);
    }

    private JsonStructureType getStructureType(IJsonType type) {
        if (type instanceof JsonListType) {
            return this.getStructureType(((JsonListType)type).getComponentType());
        }
        if (type instanceof JsonStructureType) {
            return (JsonStructureType)type;
        }
        return null;
    }

    public JsonStructureType getType() {
        return this._type;
    }

    public void updateFile(IFile file) {
        super.updateFile(file);
        this.init();
    }

    void report(DiagnosticListener<JavaFileObject> errorHandler) {
        if (this._issues == null || errorHandler == null) {
            return;
        }
        SourceJavaFileObject file = new SourceJavaFileObject(this.getFile().toURI());
        for (IIssue issue : this._issues.getIssues()) {
            Diagnostic.Kind kind = issue.getKind() == IIssue.Kind.Error ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
            errorHandler.report((Diagnostic<JavaFileObject>)new JavacDiagnostic((JavaFileObject)file, kind, (long)issue.getStartOffset(), (long)issue.getLine(), (long)issue.getColumn(), issue.getMessage()));
        }
    }
}

