/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import manifold.api.json.IJsonType;
import manifold.api.json.schema.JsonSchemaTransformer;
import manifold.internal.runtime.Bootstrap;
import manifold.util.Pair;

public class JsonSchemaTransformerSession {
    private static final ThreadLocal<JsonSchemaTransformerSession> INSTANCE;
    private Map<URL, Pair<IJsonType, JsonSchemaTransformer>> _baseTypeByUrl = new HashMap<URL, Pair<IJsonType, JsonSchemaTransformer>>();
    private Stack<JsonSchemaTransformer> _transformers = new Stack();

    public static JsonSchemaTransformerSession instance() {
        JsonSchemaTransformerSession instance = INSTANCE.get();
        if (instance == null) {
            instance = new JsonSchemaTransformerSession();
            INSTANCE.set(instance);
        }
        return instance;
    }

    private JsonSchemaTransformerSession() {
    }

    void pushTransformer(JsonSchemaTransformer transformer) {
        this._transformers.push(transformer);
    }

    void popTransformer(JsonSchemaTransformer transformer) {
        if (this._transformers.peek() != transformer) {
            throw new IllegalStateException("Unbalanced transformer pop");
        }
        this._transformers.pop();
        if (this._transformers.size() == 0) {
            this._baseTypeByUrl.clear();
        }
    }

    Pair<IJsonType, JsonSchemaTransformer> getCachedBaseType(URL url) {
        return this._baseTypeByUrl.get(url);
    }

    void cacheBaseType(URL url, Pair<IJsonType, JsonSchemaTransformer> pair) {
        this._baseTypeByUrl.put(url, pair);
    }

    static {
        Bootstrap.init();
        INSTANCE = new ThreadLocal();
    }
}

