/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import manifold.api.json.Token;
import manifold.api.json.TokenType;
import manifold.api.json.Tokenizer;
import manifold.internal.runtime.Bootstrap;
import manifold.util.Pair;

final class SimpleParserImpl {
    private final Tokenizer _tokenizer;
    private Token _token;
    private final List<String> _errors;
    private boolean _useBig;
    private boolean _withTokens;

    SimpleParserImpl(Tokenizer tokenizer, boolean useBig) {
        this._tokenizer = tokenizer;
        this._useBig = useBig;
        this._errors = new ArrayList<String>();
        this.advance();
    }

    Object parse() {
        return this.parse(false);
    }

    Object parse(boolean withTokens) {
        this._withTokens = withTokens;
        Object val = null;
        if (this._token.isValueType()) {
            val = this.parseValue();
        } else {
            this.addError();
        }
        return val;
    }

    private void advance() {
        this._token = this._tokenizer.next();
    }

    private Object parseArray() {
        ArrayList<Object> arr = new ArrayList<Object>();
        this.advance();
        if (this._token.isValueType()) {
            arr.add(this.parseValue());
            while (this._token.getType() == TokenType.COMMA) {
                this.advance();
                arr.add(this.parseValue());
            }
        }
        this.checkAndSkip(TokenType.RSQUARE, "]");
        return arr;
    }

    private Object parseObject() {
        SimpleBindings map = new SimpleBindings();
        this.advance();
        if (this._token.getType() == TokenType.STRING) {
            this.parseMember(map);
            while (this._token.getType() == TokenType.COMMA) {
                this.advance();
                this.parseMember(map);
            }
        }
        this.checkAndSkip(TokenType.RCURLY, "}");
        return map;
    }

    private void parseMember(Bindings map) {
        Token keyToken = this._token;
        String key = this._token.getString();
        this.check(TokenType.STRING, "a string");
        this.check(TokenType.COLON, ":");
        Token valueToken = this._token;
        Object val = this.parseValue();
        map.put(key, this._withTokens ? new Pair((Object)new Token[]{keyToken, valueToken}, val) : val);
    }

    private Object parseValue() {
        Object val;
        switch (this._token.getType()) {
            case LCURLY: {
                val = this.parseObject();
                break;
            }
            case LSQUARE: {
                val = this.parseArray();
                break;
            }
            case INTEGER: {
                if (this._useBig) {
                    val = new BigInteger(this._token.getString());
                } else {
                    try {
                        val = Integer.parseInt(this._token.getString());
                    }
                    catch (NumberFormatException e0) {
                        try {
                            val = Long.parseLong(this._token.getString());
                        }
                        catch (NumberFormatException e1) {
                            val = 0;
                        }
                    }
                }
                this.advance();
                break;
            }
            case DOUBLE: {
                val = this._useBig ? new BigDecimal(this._token.getString()) : Double.valueOf(Double.parseDouble(this._token.getString()));
                this.advance();
                break;
            }
            case STRING: {
                val = this._token.getString();
                this.advance();
                break;
            }
            case TRUE: {
                val = true;
                this.advance();
                break;
            }
            case FALSE: {
                val = false;
                this.advance();
                break;
            }
            case NULL: {
                val = null;
                this.advance();
                break;
            }
            default: {
                val = null;
                this.addError();
            }
        }
        return val;
    }

    private void addError() {
        this._errors.add("[" + this._token.getLineNumber() + ":" + this._token.getColumn() + "] Unexpected token '" + this._token.getString() + "'");
        this.advance();
    }

    private void check(TokenType type, String s) {
        if (this._token.getType() != type) {
            this._errors.add("[" + this._token.getLineNumber() + ":" + this._token.getColumn() + "] expecting '" + s + "', found '" + this._token.getString() + "'");
        }
        this.advance();
    }

    private void checkAndSkip(TokenType type, String s) {
        if (this._token.getType() != type) {
            this._errors.add("[" + this._token.getLineNumber() + ":" + this._token.getColumn() + "] expecting '" + s + "', found '" + this._token.getString() + "'");
            while (this._token.getType() != TokenType.EOF && this._token.getType() != type) {
                this.advance();
            }
        }
        this.advance();
    }

    List<String> getErrors() {
        return this._errors;
    }

    static {
        Bootstrap.init();
    }
}

